﻿using APSEED_SCO.Models;
using Microsoft.SqlServer.Management.Smo;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class ReportsController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();

        //  Field Employee Records
        [HttpGet]
        [Route("Reports/GetFEReports")]
        public HttpResponseMessage GetFEReports(Nullable<int> year, Nullable<int> month, Nullable<int> day, Nullable<DateTime> FromDate, Nullable<DateTime> ToDate)
        {
            var Details = APSeedCo_Entity.Sp_FeildEmployeeDetails(year, month, day, FromDate, ToDate).ToList();
            return Request.CreateResponse(HttpStatusCode.OK, Details);
        }

        //  Field Employee Records By UserId
        [HttpGet]
        [Route("Reports/GetFEReports")]
        public HttpResponseMessage GetFEReportsByUserId(Nullable<int> year, Nullable<int> month, Nullable<int> day, Nullable<DateTime> FromDate, Nullable<DateTime> ToDate,int userId)
        {
            var Details = APSeedCo_Entity.Sp_FeildEmployeeDetailsByUserId(year, month, day, FromDate, ToDate,userId).ToList();
            return Request.CreateResponse(HttpStatusCode.OK, Details);
        }

        // Get WorkRequest Details
        [HttpGet]
        [Route("Reports/GetWRReports")]
        public HttpResponseMessage GetWRReports(Nullable<int> year, Nullable<int> month, Nullable<int> day, Nullable<DateTime> FromDate, Nullable<DateTime> ToDate)
        {
           
            var Details = APSeedCo_Entity.sp_WorkRequestDetails(year, month, day, FromDate, ToDate).ToList();
            return Request.CreateResponse(HttpStatusCode.OK, Details);
        }
        
        // Workrequestfulfilment Records
        [HttpGet]
        [Route("Reports/GetWRFReports")]
        public HttpResponseMessage GetWRFReports(Nullable<int> year, Nullable<int> month, Nullable<int> day, Nullable<DateTime> FromDate, Nullable<DateTime> ToDate)
        {
            var Details = APSeedCo_Entity.sp_WorkRequestfulfilment(year, month, day, FromDate, ToDate).ToList();
            return Request.CreateResponse(HttpStatusCode.OK, Details);
        }
        
        // ProjectAbstract records
        [HttpGet]
        [Route("Reports/GetProjAbsReports")]
        public HttpResponseMessage GetprojAbsReports(Nullable<int> year, Nullable<int> month, Nullable<int> day, Nullable<DateTime> FromDate, Nullable<DateTime> ToDate)
        {
            var Details = APSeedCo_Entity.Sp_ProjAbstractDetails(year, month, day, FromDate, ToDate).ToList();
            return Request.CreateResponse(HttpStatusCode.OK, Details);
        }

        // Indent records
        [HttpGet]
        [Route("Reports/GetIndentReports")]
        public HttpResponseMessage GetIndentReports(Nullable<int> year, Nullable<int> month, Nullable<int> day, Nullable<DateTime> FromDate, Nullable<DateTime> ToDate)
        {
            var Details = APSeedCo_Entity.Sp_indentfulfilmentDetails(year, month, day, FromDate, ToDate).ToList();
            return Request.CreateResponse(HttpStatusCode.OK, Details);
        } 
    }
}