﻿using APSEED_SCO.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class FieldEmpController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();

        // Adding/Updating FieldEmployeeTracking
     
        [HttpPost]
        [Route("FieldEmp/FieldEmployeeTracking")]
        public HttpResponseMessage SaveFieldEmpTracking(SCO_FieldEmpTracking vfieldemp)
        {
            if (vfieldemp != null)
            {
                if (vfieldemp.Id > 0)
                {
                    var FieldEmp = APSeedCo_Entity.SCO_FieldEmpTracking
                        .Where(emp => emp.Id == vfieldemp.Id).SingleOrDefault();
                    if (FieldEmp == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"FieldEmployee doesnot exist with the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        FieldEmp.UserId = vfieldemp.UserId;
                        FieldEmp.PurposeOfVisit = vfieldemp.PurposeOfVisit;
                        FieldEmp.WRId = vfieldemp.WRId;
                        FieldEmp.InventoryId = vfieldemp.InventoryId;
                        FieldEmp.IndentFulfilmentId = vfieldemp.IndentFulfilmentId;
                        FieldEmp.ProjectId = vfieldemp.ProjectId;
                        FieldEmp.Distance = Math.Round( Convert.ToDouble(vfieldemp.Distance), 2, MidpointRounding.ToEven);
                        FieldEmp.PricePerKm = vfieldemp.PricePerKm;
                        FieldEmp.TotalPrice = vfieldemp.TotalPrice;
                        FieldEmp.ApporvalStatus = vfieldemp.ApporvalStatus;
                        FieldEmp.ApprovedTime = vfieldemp.ApprovedTime;
                        FieldEmp.ApprovedBy = vfieldemp.ApprovedBy;
                        FieldEmp.Remarks = vfieldemp.Remarks;
                        FieldEmp.CreatedDate = DateTime.Now;
                        FieldEmp.ModifiedDate = DateTime.Now;
                        FieldEmp.PicId = vfieldemp.PicId;
                        FieldEmp.StartLatitude = vfieldemp.StartLatitude;
                        FieldEmp.StartLongitude = vfieldemp.StartLongitude;
                        FieldEmp.StopLatitude = vfieldemp.StopLatitude;
                        FieldEmp.StopLongitude = vfieldemp.StopLatitude;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "FieldEmployee tracked successfully");
                    }
                }
                else
                {
                    SCO_FieldEmpTracking fieldEmpObj = new SCO_FieldEmpTracking();
                    fieldEmpObj.UserId = vfieldemp.UserId;
                    fieldEmpObj.PurposeOfVisit = vfieldemp.PurposeOfVisit;
                    fieldEmpObj.WRId = vfieldemp.WRId;
                    fieldEmpObj.InventoryId = vfieldemp.InventoryId;
                    fieldEmpObj.ProjectId = vfieldemp.ProjectId;
                    fieldEmpObj.IndentFulfilmentId = vfieldemp.IndentFulfilmentId;
                    fieldEmpObj.Distance = Math.Round(Convert.ToDouble(vfieldemp.Distance), 2, MidpointRounding.ToEven);
                    fieldEmpObj.PricePerKm = vfieldemp.PricePerKm;
                    fieldEmpObj.TotalPrice = vfieldemp.TotalPrice;
                    fieldEmpObj.ApporvalStatus = vfieldemp.ApporvalStatus;
                    fieldEmpObj.ApprovedTime = vfieldemp.ApprovedTime;
                    fieldEmpObj.ApprovedBy = vfieldemp.ApprovedBy;
                    fieldEmpObj.Remarks = vfieldemp.Remarks;
                    if (fieldEmpObj.WRId != null)
                    {
                        fieldEmpObj.AssetId = vfieldemp.AssetId;
                        fieldEmpObj.AssetQuantity = vfieldemp.AssetQuantity;

                    }
                    if (fieldEmpObj.InventoryId != null)
                    {
                        var inventoryDetails = APSeedCo_Entity.SCO_Inventory.Where(inv => inv.Id == fieldEmpObj.InventoryId).SingleOrDefault();
                        fieldEmpObj.AssetId = inventoryDetails.AssetId;
                        fieldEmpObj.AssetQuantity = inventoryDetails.AssetQuantity;

                    }
                    if (fieldEmpObj.IndentFulfilmentId != null)
                    {
                        var indentDetails = APSeedCo_Entity.SCO_IndentFulfilment.Where(indent => indent.Id == fieldEmpObj.IndentFulfilmentId).SingleOrDefault();
                        fieldEmpObj.AssetId = indentDetails.AssetId;
                        fieldEmpObj.AssetQuantity = indentDetails.FixedAssetCount;
                    }

                    fieldEmpObj.CreatedDate = DateTime.Now;
                    fieldEmpObj.ModifiedDate = DateTime.Now;
                    fieldEmpObj.PicId = vfieldemp.PicId;
                    fieldEmpObj.StartLatitude = vfieldemp.StartLatitude;
                    fieldEmpObj.StartLongitude = vfieldemp.StartLongitude;
                    fieldEmpObj.StopLatitude = vfieldemp.StopLatitude;
                    fieldEmpObj.StopLongitude = vfieldemp.StopLatitude;
                    APSeedCo_Entity.SCO_FieldEmpTracking.Add(fieldEmpObj);
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "FieldEmployee tracked successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"please provide atleast one field"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get field Emp tracking details 
        [HttpGet]
        [Route("FieldEmp/GetFieldEmpDetails")]
        public HttpResponseMessage GetFieldEmpTrackingDetails()
        {
            var emptrackingDetails = APSeedCo_Entity.SCO_FieldEmpTracking.ToList();
            if (emptrackingDetails != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, emptrackingDetails);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the FieldEmployee details details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get Field Employee details by userId
        [HttpGet]
        [Route("FieldEmp/GetFieldEmpDetailsById")]
        public HttpResponseMessage GetFieldEmpTrackingDetails(int userId)
        {
            var emptrackingDetails = APSeedCo_Entity.SCO_FieldEmpTracking.Where(emp => emp.UserId == userId).ToList();
            if (emptrackingDetails != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, emptrackingDetails);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the FieldEmployee details details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get FieldEmployee Users
        [HttpGet]
        [Route("FieldEmp/GetFEUsers")]
        public HttpResponseMessage GetFEUsers()
        {
            var feUsers = APSeedCo_Entity.FeildEmpDetails_view.Select(fe => fe.UserId).ToList().Distinct();
            List<FeUsers> feList = new List<FeUsers>();
            foreach(var userId in feUsers)
            {
                var userDetails = APSeedCo_Entity.SCO_User.Where(d => d.Id == userId).SingleOrDefault();
                FeUsers feObj = new FeUsers();
                feObj.UserId =Convert.ToInt64(userId);
                feObj.UserName = userDetails.FirstName + userDetails.LastName;
                feList.Add(feObj);
            }
            if (feList != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, feList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"FieldEmployee users are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Insert Image  
        [HttpPost]
        [Route("FieldEmp/InsertImage")]
        public HttpResponseMessage InsertImage()
        {
            string imageName = null;
            HttpFileCollection fileCollection = HttpContext.Current.Request.Files;
            string ids = "";
            string timestamp = DateTime.Now.ToString("yyyyMMddHHmmssfff");
            //Upload image
            for (int i = 0; i <= fileCollection.Count - 1; i++)
            {
                var postedfile = fileCollection[i];
                //Create custom FileName
                imageName = Path.GetFileNameWithoutExtension(postedfile.FileName);
                string Folderpath = postedfile.FileName;
                string imagexte = Path.GetExtension(postedfile.FileName);
                string ProjectFolder = Folderpath.Split('/')[0];
                if (ProjectFolder == "Inventory")
                {
                    string subdirInv = @"C:\Projects\APSEEDCO\Pictures\" + ProjectFolder;
                    //string subdirInv = @"E:\NetworkObjects\Projects\APSEED\APSeedSevice\APSEED_SCO\Pictures\" + ProjectFolder;
                    if (!Directory.Exists(subdirInv))
                    {
                        Directory.CreateDirectory(subdirInv);
                    }
                    var filePathInv = HttpContext.Current.Server.MapPath("~/Pictures/" + ProjectFolder + '/' + imageName + '_' + timestamp + imagexte);
                    var pathNameInv = "Pictures/" + ProjectFolder + '/' + imageName + '_' + timestamp + imagexte;
                    postedfile.SaveAs(filePathInv);
                    ImageBlob imageObjInv = new ImageBlob();
                    imageObjInv.ImagePath = pathNameInv;
                    imageObjInv.CreatedDate = DateTime.Now;
                    imageObjInv.ModifiedDate = DateTime.Now;
                    imageObjInv.IsActive = true;
                    APSeedCo_Entity.ImageBlobs.Add(imageObjInv);
                    APSeedCo_Entity.SaveChanges();
                    var idCollect = APSeedCo_Entity.ImageBlobs
                        .Where(c => c.ImagePath == imageObjInv.ImagePath).SingleOrDefault();
                    if (idCollect != null)
                    {
                        ids = Convert.ToString(idCollect.Id) + ";" + ids;
                    }
                }
                else
                {
                    string IndentStatus = Folderpath.Split('/')[1];
                    //string subdir = @"E:\NetworkObjects\Projects\APSEED\APSeedSevice\APSEED_SCO\Pictures\" + ProjectFolder;
                    string subdir = @"C:\Projects\APSEEDCO\Pictures\" + ProjectFolder;
                    if (!Directory.Exists(subdir))
                    {
                        Directory.CreateDirectory(subdir);
                    }
                    var filePath = HttpContext.Current.Server.MapPath("~/Pictures/" + ProjectFolder + '/' + imageName + '_' + IndentStatus + '_' + timestamp + imagexte);
                    var pathName = "Pictures/" + ProjectFolder + '/' + imageName + '_' + IndentStatus + '_' + timestamp + imagexte;
                    postedfile.SaveAs(filePath);
                    ImageBlob imageObj = new ImageBlob();
                    imageObj.ImagePath = pathName;
                    imageObj.CreatedDate = DateTime.Now;
                    imageObj.ModifiedDate = DateTime.Now;
                    imageObj.IsActive = true;
                    APSeedCo_Entity.ImageBlobs.Add(imageObj);
                    APSeedCo_Entity.SaveChanges();
                    var idCollect = APSeedCo_Entity.ImageBlobs
                        .Where(c => c.ImagePath == imageObj.ImagePath).SingleOrDefault();
                    if (idCollect != null)
                    {
                        ids = Convert.ToString(idCollect.Id) + ";" + ids;
                    }
                }
            }
            return Request.CreateResponse(HttpStatusCode.OK, ids);

        }

        // Fetching  Images 
        [HttpGet]
        [Route("FieldEmp/GetImages")]
        public HttpResponseMessage GetImages(string vimageId)
        {
            List<ImageIds> listobjNew = new List<ImageIds>();
            List<string> listObj = new List<string>();
            listObj = vimageId.Split(';').ToList();
            foreach (var sel in listObj)
            {
                if (sel != "")
                {
                    long selnum = Convert.ToInt64(sel);
                    var imageDetails = APSeedCo_Entity.ImageBlobs.Where(img => img.Id == selnum).SingleOrDefault();
                    ImageIds imgobj = new ImageIds();
                    imgobj.ImageId = imageDetails.Id;
                    imgobj.ImagePath = imageDetails.ImagePath;
                    listobjNew.Add(imgobj);
                }
                else
                {

                }
            }
            if (listobjNew != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, listobjNew);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the images"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get  Field Employee projects 
        [HttpGet]
        [Route("FieldEmp/GetFEProjects")]
        public HttpResponseMessage GetFEProjects()
        {
            var feProjects = APSeedCo_Entity.FeildEmpDetails_view.Select(fe => fe.ProjectId).ToList().Distinct();
            List<FeProjects> feList = new List<FeProjects>();
            foreach (var projId in feProjects)
            {
                FeProjects feObj = new FeProjects();
                if (projId == null)
                {
                    feObj.ProjectId = 0;
                    feObj.ProjectName = null;
                }
                else
                {
                    var projDetails = APSeedCo_Entity.SCO_Project.Where(d => d.Id == projId).SingleOrDefault();

                    feObj.ProjectId = Convert.ToInt64(projId);
                    feObj.ProjectName = projDetails.ProjectName;
                    feList.Add(feObj);
                }
            }
            if (feList != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, feList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"FieldEmployee projects are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get  Field Employee projects 
        [HttpGet]
        [Route("FieldEmp/GetFEProjectsByUserId")]
        public HttpResponseMessage GetFEProjects(int userId)
        {
            var feProjects = APSeedCo_Entity.FeildEmpDetails_view.Where(fe => fe.UserId == userId).Select(fe => fe.ProjectId).ToList().Distinct();
            List<FeProjects> feList = new List<FeProjects>();
            foreach (var projId in feProjects)
            {
                FeProjects feObj = new FeProjects();
                if (projId == null)
                {
                    feObj.ProjectId = 0;
                    feObj.ProjectName = null;
                }
                else
                {
                    var projDetails = APSeedCo_Entity.SCO_Project.Where(d => d.Id == projId).SingleOrDefault();
                    feObj.ProjectId = Convert.ToInt64(projId);
                    feObj.ProjectName = projDetails.ProjectName;
                    feList.Add(feObj);
                }
            }
            if (feList != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, feList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"FieldEmployee projects are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Get  Field Employee Status 
        [HttpGet]
        [Route("FieldEmp/GetFEStatus")]
        public HttpResponseMessage GetFEStatus()
        {
            var feStatus = APSeedCo_Entity.FeildEmpDetails_view.Select(fe => fe.IndentStatus).ToList().Distinct();
            List<FeProjects> feList = new List<FeProjects>();
            foreach (var WStatus in feStatus)
            {
                FeProjects feObj = new FeProjects();
                feObj.WorkStatus = WStatus;
                feList.Add(feObj);
            }
            if (feList != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, feList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"FieldEmployee status is not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Get  Field Employee Status By UserId
        [HttpGet]
        [Route("FieldEmp/GetFEStatusByUserId")]
        public HttpResponseMessage GetFEStatusByUserId(int userId)
        {
            var feStatus = APSeedCo_Entity.FeildEmpDetails_view.Where(fe=>fe.UserId==userId).Select(fe => fe.IndentStatus).ToList().Distinct();
            List<FeProjects> feList = new List<FeProjects>();
            foreach (var WStatus in feStatus)
            {
                FeProjects feObj = new FeProjects();
                feObj.WorkStatus = WStatus;
                feList.Add(feObj);
            }
            if (feList != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, feList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"FieldEmployee status is not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        public class ImageIds
        {
            public long ImageId { get; set; }
            public string ImagePath { get; set; }
        }

        public class FeUsers
        {
            public long UserId { get; set; }
            public string UserName { get; set; }
        }

        public class FeProjects
        {
            public long ProjectId { get; set; }
            public string ProjectName { get; set;}
            public string WorkStatus { get; set; }
        }
    }
}