﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using APSEED_SCO.Models;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class WorkRequestController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();
        // Save WorkRequest
        [HttpPost]
        [Route("WorkRequest/SaveWorkRequest")]
        public HttpResponseMessage SaveWorkRequest(SCO_WorkRequest vworkRequest)
        {
            if (vworkRequest != null)
            {
                if (vworkRequest.Id > 0)
                {
                    var WRIDFind = APSeedCo_Entity.SCO_WorkRequest.Where(wr => wr.Id == vworkRequest.Id && wr.IsActive == true).SingleOrDefault();
                    if (WRIDFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {

                            Content = new StringContent($"WorkRequest does not exists with Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        var projectIdCheck = APSeedCo_Entity.SCO_WorkRequest.Where(wr => wr.ProjectId == vworkRequest.ProjectId && wr.RequestType == vworkRequest.RequestType && wr.IsActive == true
                ).SingleOrDefault();
                        if (projectIdCheck == null)
                        {
                            WRIDFind.UserId = vworkRequest.UserId;
                            WRIDFind.ModifiedDate = DateTime.Now;
                            WRIDFind.ValidFrom = vworkRequest.ValidFrom;
                            WRIDFind.ValidUntil = vworkRequest.ValidUntil;
                            WRIDFind.RequestType = vworkRequest.RequestType;

                            WRIDFind.ModifiedDate = DateTime.Now;
                            WRIDFind.WorkStart = vworkRequest.WorkStart;
                            WRIDFind.WorkStop = vworkRequest.WorkStop;
                            WRIDFind.Latitude = vworkRequest.Latitude;
                            WRIDFind.Longitude = vworkRequest.Longitude;
                            APSeedCo_Entity.SaveChanges();
                            return Request.CreateResponse(HttpStatusCode.OK, "WorkRequest updated successfully");
                        }
                        else
                        {
                            if (WRIDFind.RequestType == vworkRequest.RequestType)
                            {
                                WRIDFind.UserId = vworkRequest.UserId;
                                WRIDFind.ModifiedDate = DateTime.Now;
                                WRIDFind.ValidFrom = vworkRequest.ValidFrom;
                                WRIDFind.ValidUntil = vworkRequest.ValidUntil;
                                WRIDFind.RequestType = vworkRequest.RequestType;
                                WRIDFind.ModifiedDate = DateTime.Now;
                                WRIDFind.WorkStart = vworkRequest.WorkStart;
                                WRIDFind.WorkStop = vworkRequest.WorkStop;
                                WRIDFind.Latitude = vworkRequest.Latitude;
                                WRIDFind.Longitude = vworkRequest.Longitude;
                                APSeedCo_Entity.SaveChanges();
                                return Request.CreateResponse(HttpStatusCode.OK, "WorkRequest updated successfully");
                            }
                            else
                            {
                                return Request.CreateResponse(HttpStatusCode.BadRequest, "WorkRequest" + vworkRequest.RequestType + " already exists. Can not change request type now.");
                            }
                        }
                    }
                }
                else
                {
                    var projectIdFind = APSeedCo_Entity.SCO_WorkRequest.Where(wr => wr.ProjectId == vworkRequest.ProjectId && wr.RequestType == vworkRequest.RequestType && wr.IsActive == true
                    ).SingleOrDefault();
                    if (projectIdFind == null)
                    {
                        SCO_WorkRequest WRObj = new SCO_WorkRequest();
                        var vProjectFind = APSeedCo_Entity.SCO_Project
                            .Where(project => project.Id == vworkRequest.ProjectId).SingleOrDefault();
                        WRObj.ProjectId = vProjectFind.Id;
                        WRObj.UserId = vworkRequest.UserId;
                        WRObj.ProjectName = vProjectFind.ProjectName;
                        WRObj.CreatedDate = DateTime.Now;
                        WRObj.CreatedBy = vworkRequest.CreatedBy;
                        WRObj.RequestType = vworkRequest.RequestType;
                        WRObj.Latitude = vworkRequest.Latitude;
                        WRObj.Longitude = vworkRequest.Longitude;
                        WRObj.ValidFrom = vworkRequest.ValidFrom;
                        WRObj.ValidUntil = vworkRequest.ValidUntil;
                        WRObj.IsActive = true;
                        WRObj.WorkStart = true;
                        WRObj.WorkStop = false;
                        APSeedCo_Entity.SCO_WorkRequest.Add(WRObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "WorkRequest created successfully");
                    }
                    else
                    {
                        var indentFind = APSeedCo_Entity.SCO_IndentFulfilment.Where(indent => indent.ProjectId == vworkRequest.ProjectId && indent.IsActive == true).FirstOrDefault();
                        if (indentFind == null)
                        {
                            throw new HttpResponseException(new HttpResponseMessage
                            {
                                Content = new StringContent($"" + vworkRequest.RequestType + " " + "Work request already in progress"),
                                StatusCode = HttpStatusCode.BadRequest
                            });
                        }
                        else
                        {
                            SCO_WorkRequest WRObj = new SCO_WorkRequest();
                            var vProjectFind = APSeedCo_Entity.SCO_Project
                                .Where(project => project.Id == vworkRequest.ProjectId).SingleOrDefault();
                            WRObj.ProjectId = vProjectFind.Id;
                            WRObj.UserId = vworkRequest.UserId;
                            WRObj.ProjectName = vProjectFind.ProjectName;
                            WRObj.CreatedDate = DateTime.Now;
                            WRObj.CreatedBy = vworkRequest.CreatedBy;
                            WRObj.RequestType = vworkRequest.RequestType;
                            WRObj.Latitude = vworkRequest.Latitude;
                            WRObj.Longitude = vworkRequest.Longitude;
                            WRObj.ValidFrom = vworkRequest.ValidFrom;
                            WRObj.ValidUntil = vworkRequest.ValidUntil;
                            WRObj.IsActive = true;
                            WRObj.WorkStart = true;
                            WRObj.WorkStop = false;
                            APSeedCo_Entity.SCO_WorkRequest.Add(WRObj);
                            APSeedCo_Entity.SaveChanges();
                            return Request.CreateResponse(HttpStatusCode.OK, "WorkRequest created successfully");
                        }
                    }
                    throw new HttpResponseException(new HttpResponseMessage
                    {
                        Content = new StringContent($"" + vworkRequest.RequestType + "Work request exits"),
                        StatusCode = HttpStatusCode.BadRequest
                    });
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Delete WorkRequest 
        [HttpGet]
        [Route("WorkRequest/DeleteWorkRequest")]
        public HttpResponseMessage DeleteWorkRequest(int wrId)
        {
            var deleteWorkRequest = APSeedCo_Entity.SCO_WorkRequest
                .Where(wr => wr.Id == wrId && wr.IsActive == true).SingleOrDefault();
            if (deleteWorkRequest != null)
            {
                var wrfDetails = APSeedCo_Entity.SCO_WorkRequestFulfilment.Where(wrf => wrf.WRId == wrId && wrf.IsActive == true).FirstOrDefault();
                if (wrfDetails == null)
                {
                    deleteWorkRequest.IsActive = false;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "WorkRequest deleted successfully");
                }
                else
                {
                    throw new HttpResponseException(new HttpResponseMessage
                    {
                        Content = new StringContent($"Workrequestfulfiment avaliable so cannot disabled wokrequest"),
                        StatusCode = HttpStatusCode.BadRequest
                    });
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Workrequest does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Delete WorkRequest 
        public void DeleteWork(long wrId)
        {
            var deleteWorkRequest = APSeedCo_Entity.SCO_WorkRequest
                .Where(wr => wr.Id == wrId).SingleOrDefault();
            if (deleteWorkRequest != null)
            {
                deleteWorkRequest.IsActive = false;
                APSeedCo_Entity.SaveChanges();

            }
            var deleteWRF = APSeedCo_Entity.SCO_WorkRequestFulfilment.Where(wrf => wrf.WRId == wrId).ToList();
            if (deleteWRF != null)
            {
                foreach (var del in deleteWRF)
                {
                    del.IsActive = false;
                }
                APSeedCo_Entity.SaveChanges();
            }
        }

        // Get WRequest details
        [HttpGet]
        [Route("WorkRequest/GetWRDetails")]
        public HttpResponseMessage GetWRDetails()
        {
            var getWrDetails = APSeedCo_Entity.SCO_WorkRequest
                .Include("SCO_User").Where(wr => wr.IsActive == true)
                .ToList();
            List<WorkRequestList> WRList = new List<WorkRequestList>();
            foreach (var sel in getWrDetails)
            {
                WorkRequestList WRObj = new WorkRequestList();
                WRObj.WRId = sel.Id;
                WRObj.ProjectId = sel.ProjectId;
                var projectDetails = APSeedCo_Entity.SCO_Project.Where(proj => proj.Id == WRObj.ProjectId).SingleOrDefault();
                WRObj.ProjectName = sel.ProjectName;
                WRObj.DistrictId = Convert.ToInt64(projectDetails.DistrictId);
                var districtDetails = APSeedCo_Entity.SCO_District.Where(dist => dist.Id == WRObj.DistrictId).SingleOrDefault();
                WRObj.DistrictName = districtDetails.Name;
                WRObj.DepartmentId = Convert.ToInt64(projectDetails.DepartmentId);
                var departmentDetails = APSeedCo_Entity.SCO_Department
                    .Where(dept => dept.Id == WRObj.DepartmentId).SingleOrDefault();
                WRObj.DepartmentName = departmentDetails.Name;
                WRObj.UserId = sel.UserId;
                if (sel.SCO_User == null)
                {
                    WRObj.UserName = null;
                }
                else
                {
                    WRObj.UserName = sel.SCO_User.FirstName + sel.SCO_User.LastName;
                }
                WRObj.CreatedBy = sel.CreatedBy;
                WRObj.RequestType = sel.RequestType;
                WRObj.CreatedDate = sel.CreatedDate;
                WRObj.Latitude = sel.Latitude;
                WRObj.Longitude = sel.Longitude;
                WRObj.ValidFrom = sel.ValidFrom;
                WRObj.ValidUntil = sel.ValidUntil;
                WRObj.ModifiedDate = sel.ModifiedDate;
                WRObj.IsActive = sel.IsActive;
                WRList.Add(WRObj);
            }
            if (WRList != null)
            {
                return Request.CreateResponse<List<WorkRequestList>>(HttpStatusCode.OK, WRList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Failed to fetch the Details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("WorkRequest/GetWRDetailsByuserId")]

        public HttpResponseMessage GetWrDetailsByUserId(int userId)
        {
            var getWrDetails = APSeedCo_Entity.SCO_WorkRequest
                .Include("SCO_User").Where(WR => WR.UserId == userId && WR.IsActive == true).ToList();
            List<WorkRequestList> WRList = new List<WorkRequestList>();
            foreach (var sel in getWrDetails)
            {
                WorkRequestList WRObj = new WorkRequestList();
                WRObj.WRId = sel.Id;
                WRObj.ProjectId = sel.ProjectId;
                var projectDetails = APSeedCo_Entity.SCO_Project.Where(proj => proj.Id == WRObj.ProjectId).SingleOrDefault();
                WRObj.ProjectName = sel.ProjectName;
                WRObj.DistrictId = Convert.ToInt64(projectDetails.DistrictId);
                var districtDetails = APSeedCo_Entity.SCO_District.Where(dist => dist.Id == WRObj.DistrictId).SingleOrDefault();
                WRObj.DistrictName = districtDetails.Name;
                WRObj.DepartmentId = Convert.ToInt64(projectDetails.DepartmentId);
                var departmentDetails = APSeedCo_Entity.SCO_Department
                    .Where(dept => dept.Id == WRObj.DepartmentId).SingleOrDefault();
                WRObj.DepartmentName = departmentDetails.Name;
                WRObj.UserId = sel.UserId;
                if (sel.SCO_User == null)
                {
                    WRObj.UserName = null;
                }
                else
                {
                    WRObj.UserName = sel.SCO_User.FirstName + sel.SCO_User.LastName;
                }
                WRObj.CreatedBy = sel.CreatedBy;
                WRObj.RequestType = sel.RequestType;
                WRObj.CreatedDate = sel.CreatedDate;
                WRObj.Latitude = sel.Latitude;
                WRObj.Longitude = sel.Longitude;
                WRObj.ValidFrom = sel.ValidFrom;
                WRObj.ValidUntil = sel.ValidUntil;
                WRObj.ModifiedDate = sel.ModifiedDate;
                WRObj.IsActive = sel.IsActive;
                WRObj.WorkStart = sel.WorkStart;
                WRObj.WorkStop = sel.WorkStop;
                WRList.Add(WRObj);
            }
            if (WRList != null)
            {
                return Request.CreateResponse<List<WorkRequestList>>(HttpStatusCode.OK, WRList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Failed to fetch the Details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get WorkRequest Details By Disabled UserId
        [HttpGet]
        [Route("WorkRequest/GetDisabledWRDetails")]
        public HttpResponseMessage GetDisabledWRDetails()
        {
            var getWrDetails = APSeedCo_Entity.SCO_WorkRequest
                .Include("SCO_User").Where(WR => WR.IsActive == false).ToList();
            List<WorkRequestList> WRList = new List<WorkRequestList>();
            foreach (var sel in getWrDetails)
            {
                WorkRequestList WRObj = new WorkRequestList();
                WRObj.WRId = sel.Id;
                WRObj.ProjectId = sel.ProjectId;
                var projectDetails = APSeedCo_Entity.SCO_Project.Where(proj => proj.Id == WRObj.ProjectId).SingleOrDefault();
                WRObj.ProjectName = sel.ProjectName;
                WRObj.DistrictId = Convert.ToInt64(projectDetails.DistrictId);
                var districtDetails = APSeedCo_Entity.SCO_District.Where(dist => dist.Id == WRObj.DistrictId).SingleOrDefault();
                WRObj.DistrictName = districtDetails.Name;
                WRObj.DepartmentId = Convert.ToInt64(projectDetails.DepartmentId);
                var departmentDetails = APSeedCo_Entity.SCO_Department
                    .Where(dept => dept.Id == WRObj.DepartmentId).SingleOrDefault();
                WRObj.DepartmentName = departmentDetails.Name;
                WRObj.RequestType = sel.RequestType;
                WRObj.UserId = sel.UserId;
                if (sel.SCO_User == null)
                {
                    WRObj.UserName = null;
                }
                else
                {
                    WRObj.UserName = sel.SCO_User.FirstName + sel.SCO_User.LastName;
                }

                WRList.Add(WRObj);
            }
            if (WRList != null)
            {
                return Request.CreateResponse<List<WorkRequestList>>(HttpStatusCode.OK, WRList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Failed to fetch the Details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Enable of disabled WorkRequest
        [HttpGet]
        [Route("WorkRequest/EnabledOrDisabledWR")]
        public HttpResponseMessage EnabledOrDisabledWR(int WRId, bool status)
        {
            var WRFind = APSeedCo_Entity.SCO_WorkRequest.Where(WR => WR.Id == WRId).SingleOrDefault();
            var WRFFind = APSeedCo_Entity.SCO_WorkRequestFulfilment.Where(WRF => WRF.WRId == WRId).ToList();
            if (WRFind != null)
            {
                if (status == false)
                {
                    var IndentFind = APSeedCo_Entity.SCO_IndentFulfilment
                        .Where(indent => indent.WRID == WRId).FirstOrDefault();
                    if (IndentFind == null)
                    {
                        WRFind.IsActive = true;
                        foreach (var sel in WRFFind)
                        {
                            sel.IsActive = true;
                        }
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "WorkRequest & WRFulfiment enabled successfully");
                    }
                    else
                    {
                        return Request.CreateResponse(HttpStatusCode.BadRequest, " Indent is InProgress so cannot enable WorkRequest");
                    }

                }
                else
                {
                    return Request.CreateResponse(HttpStatusCode.BadRequest, "Error" +
                        "");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"WorkRequest does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Methods  related to workRequest controller

        [HttpPost]
        [Route("WorkRequest/updateWorkRequestFulfillment")]
        public HttpResponseMessage UpdateWorkRequestFulfilment(SCO_WorkRequestFulfilment vworkRequest)
        {
            if (vworkRequest.Id > 0)
            {
                var WRFind = APSeedCo_Entity.SCO_WorkRequestFulfilment
                    .Where(WRF => WRF.Id == vworkRequest.Id).SingleOrDefault();
                if (WRFind == null)
                {
                    throw new HttpResponseException(new HttpResponseMessage
                    {
                        Content = new StringContent($"WorkRequestFulfilment details does not exist with the Id"),
                        StatusCode = HttpStatusCode.BadRequest
                    });
                }
                else
                {
                    WRFind.WRId = vworkRequest.WRId;
                    WRFind.AssetId = vworkRequest.AssetId;
                    WRFind.Description = vworkRequest.Description;
                    WRFind.AssetTypeId = vworkRequest.AssetTypeId;
                    WRFind.AssetQuantity = vworkRequest.AssetQuantity;
                    WRFind.ModifiedBy = vworkRequest.ModifiedBy;
                    WRFind.IsActive = true;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "WorkRequestFulfilment updated successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Getting Project from projectAbstract
        [HttpGet]
        [Route("Project/GetProjectsOfWorkRequest")]
        public HttpResponseMessage GetProjectsOfWorkRequest()
        {
            var projectDetails = APSeedCo_Entity.SCO_WorkRequest
                .ToList().Select( wr => new { wr.ProjectId,wr.ProjectName}).Distinct();
            List<WorkRequestList> projAbslist = new List<WorkRequestList>();

            foreach (var projId in projectDetails)
            {
                WorkRequestList list = new WorkRequestList();
                list.ProjectId = projId.ProjectId;
                list.ProjectName = projId.ProjectName;
                projAbslist.Add(list);
            }

            if (projAbslist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, projAbslist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Projects are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Add WorkRequestFulfilment --Save
        [HttpPost]
        [Route("WorkRequest/AddWorkRequestFulfillment")]

        public HttpResponseMessage 
            AddWorkRequestFulfilment(List<SCO_WorkRequestFulfilment> vworkRequest)
        {
            if (vworkRequest != null)
            {
                foreach (var WReqF in vworkRequest)
                {
                    SCO_WorkRequestFulfilment WRObj = new SCO_WorkRequestFulfilment();
                    var wrfDetails = APSeedCo_Entity.SCO_WorkRequestFulfilment.Where(wrf => wrf.WRId == WReqF.WRId && wrf.AssetId == WReqF.AssetId).SingleOrDefault();
                    if (wrfDetails == null)
                    {
                        WRObj.WRId = WReqF.WRId;
                        WRObj.AssetTypeId = WReqF.AssetTypeId;
                        WRObj.AssetId = WReqF.AssetId;
                        WRObj.Description = WReqF.Description;
                        WRObj.AssetQuantity = WReqF.AssetQuantity;
                        WRObj.WorkStart = true;
                        WRObj.WorkStop = false;
                        WRObj.CreatedBy = WReqF.CreatedBy;
                        WRObj.CreatedDate = DateTime.Now;
                        WRObj.IsActive = true;
                        APSeedCo_Entity.SCO_WorkRequestFulfilment.Add(WRObj);
                    }
                    else
                    {
                        wrfDetails.AssetTypeId = WReqF.AssetTypeId;
                        wrfDetails.AssetId = WReqF.AssetId;
                        wrfDetails.Description = WReqF.Description;
                        wrfDetails.AssetQuantity = wrfDetails.AssetQuantity + WReqF.AssetQuantity;
                        wrfDetails.IsActive = true;
                    }
                    APSeedCo_Entity.SaveChanges();
                }
                return Request.CreateResponse(HttpStatusCode.OK, "WorkrequestFulfilment created successfully.");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete WorkRequestFulfilment 
        [HttpGet]
        [Route("WorkRequest/DeleteWorkRequestFulfilment")]
        public HttpResponseMessage DeleteWorkRequestFulfilment(int wrfId)
        {
            var deleteWRF = APSeedCo_Entity.SCO_WorkRequestFulfilment.Where(wrf => wrf.Id == wrfId).SingleOrDefault();
            if (deleteWRF != null)
            {
                APSeedCo_Entity.SCO_WorkRequestFulfilment.Remove(deleteWRF);
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "WorkRequestFulfilment deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"WorkRequestFulfilment does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get Workrequestfulfiment Details

        [HttpGet]
        [Route("WorkRequest/GetWRFdetails")]
        public HttpResponseMessage GetWRFDetails()
        {
            var getWRFDetails = APSeedCo_Entity.SCO_WorkRequestFulfilment.Include("SCO_WorkRequest").Include("SCO_Assets").Where(wrf => wrf.IsActive == true).ToList();
            List<WorkRequestFulfilmentList> WRFList = new List<WorkRequestFulfilmentList>();
            foreach (var sel in getWRFDetails)
            {
                WorkRequestFulfilmentList WRFObj = new WorkRequestFulfilmentList();
                WRFObj.Id = sel.Id;
                WRFObj.WRId = sel.WRId;
                WRFObj.AssetId = sel.AssetId;
                WRFObj.Description = sel.Description;
                if (sel.SCO_Assets == null)
                {
                    WRFObj.AssetName = null;
                }
                else
                {
                    WRFObj.AssetName = sel.SCO_Assets.Name;
                }
                WRFObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                if (WRFObj.AssetTypeId == 0)
                {
                    WRFObj.AssetType = null;
                }
                else
                {
                    WRFObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                    var assetTypedetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == WRFObj.AssetTypeId).SingleOrDefault();
                    WRFObj.AssetType = assetTypedetails.Name;
                }
                WRFObj.AssetQuantity = Convert.ToInt64(sel.AssetQuantity);
                WRFObj.ModifiedBy = sel.ModifiedBy;
                WRFList.Add(WRFObj);
            }
            if (WRFList != null)
            {
                return Request.CreateResponse<List<WorkRequestFulfilmentList>>(HttpStatusCode.OK, WRFList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($" WorkRequestFulfiment details not found"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get WRFDetails by WorkRequestId
        [HttpGet]
        [Route("WorkRequest/GetWRFdetailsById")]
        public HttpResponseMessage GetWRFDetailsById(int wrId)
        {
            var getWRFDetails = APSeedCo_Entity.SCO_WorkRequestFulfilment.Include("SCO_WorkRequest").Include("SCO_Assets").Where(wrf => wrf.WRId == wrId && wrf.IsActive == true).ToList();
            List<WorkRequestFulfilmentList> WRFList = new List<WorkRequestFulfilmentList>();
            foreach (var sel in getWRFDetails)
            {
                WorkRequestFulfilmentList WRFObj = new WorkRequestFulfilmentList();
                WRFObj.Id = sel.Id;
                WRFObj.WRId = sel.WRId;
                if (sel.SCO_WorkRequest.ProjectId == null)
                {
                    WRFObj.ProjectId = null;
                }
                else
                {
                    WRFObj.ProjectId = sel.SCO_WorkRequest.ProjectId;
                }
                if (sel.SCO_WorkRequest.ProjectName == null)
                {
                    WRFObj.ProjectName = null;
                }
                else
                {
                    WRFObj.ProjectName = sel.SCO_WorkRequest.ProjectName;
                }
                if (sel.SCO_WorkRequest.UserId == null)
                {
                    WRFObj.UserId = null;
                    WRFObj.UserName = null;
                }
                else
                {
                    WRFObj.UserId = sel.SCO_WorkRequest.UserId;
                    var userCheck = APSeedCo_Entity.SCO_User.Where(user => user.Id == WRFObj.UserId).SingleOrDefault();
                    WRFObj.UserName = userCheck.UserName;
                }
                WRFObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                if (WRFObj.AssetTypeId == 0)
                {
                    WRFObj.AssetType = null;
                }
                else
                {
                    WRFObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                    var assetTypedetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == WRFObj.AssetTypeId).SingleOrDefault();
                    WRFObj.AssetType = assetTypedetails.Name;
                }
                WRFObj.AssetId = sel.AssetId;
                WRFObj.Description = sel.Description;
                if (sel.SCO_Assets == null)
                {
                    WRFObj.AssetName = null;
                }
                else
                {
                    WRFObj.AssetName = sel.SCO_Assets.Name;
                }
                WRFObj.AssetQuantity = Convert.ToInt64(sel.AssetQuantity);
                WRFObj.ModifiedBy = sel.ModifiedBy;
                WRFObj.WorkStart = sel.WorkStart;
                WRFObj.WorkStop = sel.WorkStop;
                WRFList.Add(WRFObj);
            }
            if (WRFList != null)
            {
                return Request.CreateResponse<List<WorkRequestFulfilmentList>>(HttpStatusCode.OK, WRFList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($" WorkRequestFulfiment details not found"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get WRFDetails by UserId

        [HttpGet]
        [Route("WorkRequest/GetWRFdetailsByUserId")]
        public HttpResponseMessage GetWRFDetailsByUserId(int wrId, int userId)
        {
            var getWRFDetails = APSeedCo_Entity.SCO_WorkRequestFulfilment.Include("SCO_WorkRequest").Include("SCO_Assets").Where(wrf => wrf.WRId == wrId && wrf.IsActive == true).ToList();
            List<WorkRequestFulfilmentList> WRFList = new List<WorkRequestFulfilmentList>();
            foreach (var sel in getWRFDetails)
            {
                WorkRequestFulfilmentList WRFObj = new WorkRequestFulfilmentList();
                if (sel.SCO_WorkRequest.UserId == userId)
                {
                    WRFObj.Id = sel.Id;
                    WRFObj.WRId = sel.WRId;
                    if (sel.SCO_WorkRequest.ProjectId == null)
                    {
                        WRFObj.ProjectId = null;
                    }
                    else
                    {
                        WRFObj.ProjectId = sel.SCO_WorkRequest.ProjectId;
                    }
                    if (sel.SCO_WorkRequest.ProjectName == null)
                    {
                        WRFObj.ProjectName = null;
                    }
                    else
                    {
                        WRFObj.ProjectName = sel.SCO_WorkRequest.ProjectName;
                    }
                    if (sel.SCO_WorkRequest.UserId == null)
                    {
                        WRFObj.UserId = null;
                        WRFObj.UserName = null;
                    }
                    else
                    {
                        WRFObj.UserId = sel.SCO_WorkRequest.UserId;
                        var userCheck = APSeedCo_Entity.SCO_User.Where(user => user.Id == WRFObj.UserId).SingleOrDefault();
                        WRFObj.UserName = userCheck.UserName;
                    }
                    WRFObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                    if (WRFObj.AssetTypeId == 0)
                    {
                        WRFObj.AssetType = null;
                    }
                    else
                    {
                        WRFObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                        var assetTypedetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == WRFObj.AssetTypeId).SingleOrDefault();
                        WRFObj.AssetType = assetTypedetails.Name;
                    }
                    WRFObj.AssetId = sel.AssetId;
                    WRFObj.Description = sel.Description;
                    if (sel.SCO_Assets == null)
                    {
                        WRFObj.AssetName = null;
                    }
                    else
                    {
                        WRFObj.AssetName = sel.SCO_Assets.Name;
                    }
                    WRFObj.AssetQuantity = Convert.ToInt64(sel.AssetQuantity);
                    WRFObj.ModifiedBy = sel.ModifiedBy;
                    WRFObj.WorkStart = true;
                    WRFObj.WorkStop = false;
                    WRFList.Add(WRFObj);
                }
                else
                {
                    throw new HttpResponseException(new HttpResponseMessage
                    {
                        Content = new StringContent($" No WorkRequestFulfiment details with the UserId"),
                        StatusCode = HttpStatusCode.BadRequest
                    });
                }
            }

            if (WRFList != null)
            {
                return Request.CreateResponse<List<WorkRequestFulfilmentList>>(HttpStatusCode.OK, WRFList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($" WorkRequestFulfiment details not found"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Getting Project from projectAbstract
        [HttpGet]
        [Route("Project/GetProjectsOfWorkRequestFulfiment")]
        public HttpResponseMessage GetProjectsOfWorkRequestFulfiment()
        {
            var projectDetails = APSeedCo_Entity.SCO_WorkRequestFulfilment.Include("SCO_WorkRequest").Where(wrf => wrf.WRId == wrf.SCO_WorkRequest.Id)
                .ToList().Select(x => new { x.SCO_WorkRequest.ProjectId, x.SCO_WorkRequest.ProjectName}).Distinct();
            List<WorkRequestList> projAbslist = new List<WorkRequestList>();

            foreach (var projId in projectDetails)
            {
                //var projDetails = APSeedCo_Entity.SCO_Project.Where(d => d.Id == projId).SingleOrDefault();
                WorkRequestList list = new WorkRequestList();
                list.ProjectId = projId.ProjectId;
                list.ProjectName = projId.ProjectName;
                projAbslist.Add(list);
            }

            if (projAbslist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, projAbslist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Projects are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Class related to WorkRequest
        public class WorkRequestList
        {
            public long WRId { get; set; }
            public Nullable<long> ProjectId { get; set; }

            public Nullable<long> UserId { get; set; }

            public long DistrictId { get; set; }
            public string DistrictName { get; set; }
            public long DepartmentId { get; set; }
            public string DepartmentName { get; set; }
            public string UserName { get; set; }
            public string ProjectName { get; set; }
            public Nullable<System.DateTime> CreatedDate { get; set; }
            public Nullable<System.DateTime> ModifiedDate { get; set; }
            public string CreatedBy { get; set; }
            public Nullable<System.DateTime> ValidFrom { get; set; }
            public Nullable<System.DateTime> ValidUntil { get; set; }
            public string RequestType { get; set; }
            public Nullable<decimal> Latitude { get; set; }
            public bool IsActive { get; set; }
            public Nullable<bool> WorkStart { get; set; }
            public Nullable<bool> WorkStop { get; set; }
            public Nullable<decimal> Longitude { get; set; }
        }

        // Class for WorkRequestFulfiment

        public class WorkRequestFulfilmentList
        {
            public long Id { get; set; }
            public Nullable<long> WRId { get; set; }
            public long AssetTypeId { get; set; }
            public string AssetType { get; set; }
            public Nullable<long> AssetId { get; set; }
            public Nullable<long> UserId { get; set; }
            public string UserName { get; set; }
            public string ProjectName { get; set; }
            public Nullable<long> ProjectId { get; set; }
            public string AssetName { get; set; }
            public string Description { get; set; }
            public long AssetQuantity { get; set; }
            public Nullable<System.DateTime> CreatedDate { get; set; }
            public string ModifiedBy { get; set; }
            public Nullable<bool> WorkStart { get; set; }
            public Nullable<bool> WorkStop { get; set; }

        }
    }
}