﻿using APSEED_SCO.Models;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class MasterController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();
        // ******************Master Data Related to Districts **************************

        // Fetching Districts Data
        [HttpGet]
        [Route("Master/GetDistricts")]
        public HttpResponseMessage GetDistricts()
        {
            var districtList = APSeedCo_Entity.SCO_District.ToList();
            if (districtList != null)
            {

                return Request.CreateResponse<List<SCO_District>>(HttpStatusCode.OK, districtList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Districts are  not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/LoadJson")]
        public HttpResponseMessage LoadJson()
        {
            string filepath = HttpContext.Current.Server.MapPath("~/Helpers/SeedCoVersionCheck.json");
            //string filepath =@"E:\NWOAPI\apseedcoservice\Helpers\SeedCoVersionCheck.json";
            using (StreamReader r = new StreamReader(filepath))
            {
                string json = r.ReadToEnd();
                List<Object> items = JsonConvert.DeserializeObject<List<Object>>(json);
                return Request.CreateResponse(HttpStatusCode.OK, items);
            }
        }

        // Adding Districts Data
        [HttpPost]
        [Route("Master/AddDistrict")]
        public HttpResponseMessage AddingDistrict(SCO_District vdistrict)
        {
            if (vdistrict != null)
            {
                if (vdistrict.Id > 0)
                {
                    SCO_District districtFind = APSeedCo_Entity.SCO_District.Where(dist => dist.Id == vdistrict.Id).SingleOrDefault();
                    if (districtFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Districts are not avaliable ith the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        districtFind.Name = vdistrict.Name;
                        districtFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Districts updated successfully");
                    }
                }
                else
                {
                    SCO_District districtFind = APSeedCo_Entity.SCO_District.Where(dist => dist.Name == vdistrict.Name).FirstOrDefault();
                    if (districtFind == null)
                    {
                        SCO_District districtObj = new SCO_District();
                        districtObj.Name = vdistrict.Name;
                        districtObj.IsActive = true;
                        APSeedCo_Entity.SCO_District.Add(districtObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "District created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"District exists with the same name"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Districts

        [HttpGet]
        [Route("Master/DeleteDistrict")]
        public HttpResponseMessage DeleteDistrict(int distId)
        {
            var deleteDistrict = APSeedCo_Entity.SCO_District
                .Where(dist => dist.Id == distId).SingleOrDefault();
            if (deleteDistrict != null)
            {
                deleteDistrict.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "District deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        //*************************Master Data Related to Mandals*************************
        // Fetching the Mandals List
        [HttpGet]
        [Route("Master/GetMandals")]

        public HttpResponseMessage GetMandals()
        {
            var mandalList = APSeedCo_Entity.SCO_Mandal.ToList();
            if (mandalList != null)
            {
                return Request.CreateResponse<List<SCO_Mandal>>(HttpStatusCode.OK, mandalList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Mandals are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Adding Mandals Data
        [HttpPost]
        [Route("Master/AddMandal")]

        public HttpResponseMessage AddingMandals(SCO_Mandal vmandal)
        {
            if (vmandal != null)
            {
                if (vmandal.Id > 0)
                {
                    SCO_Mandal mandalFind = APSeedCo_Entity.SCO_Mandal.Where(mandal => mandal.Id == vmandal.Id).FirstOrDefault();
                    if (mandalFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Mandals are not avaliable with the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        mandalFind.Name = vmandal.Name;
                        mandalFind.DistrictId = vmandal.DistrictId;
                        mandalFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Mandals updated successfully");
                    }
                }
                else
                {
                    SCO_Mandal mandalFind = APSeedCo_Entity.SCO_Mandal.Where(mandal => mandal.Name == vmandal.Name).FirstOrDefault();
                    if (mandalFind == null)
                    {
                        SCO_Mandal mandalObj = new SCO_Mandal();
                        mandalObj.DistrictId = vmandal.DistrictId;
                        mandalObj.Name = vmandal.Name;
                        mandalObj.IsActive = true;
                        APSeedCo_Entity.SCO_Mandal.Add(mandalObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Mandal created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Mandal exists with the same name "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        // Fetch Mandals based on District Id

        [HttpGet]
        [Route("Master/MandalByDistrictId")]
        public HttpResponseMessage GetMandalsByDistrictId(int vdistrictId)
        {
            var mandalListById = APSeedCo_Entity.SCO_Mandal.Where(mandal => mandal.DistrictId == vdistrictId).Select(mandal => new { mandal.Id, mandal.Name }).ToList();
            List<MandalsList> vmandals = new List<MandalsList>();
            foreach (var sel in mandalListById)
            {
                MandalsList mandalObj = new MandalsList();
                mandalObj.Id = sel.Id;
                mandalObj.Name = sel.Name;
                vmandals.Add(mandalObj);
            }
            if (vmandals != null)
            {
                return Request.CreateResponse<List<MandalsList>>(HttpStatusCode.OK, vmandals);
            }

            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Mandals not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Mandal
        [HttpGet]
        [Route("Master/DeleteMandal")]
        public HttpResponseMessage DeleteMandal(int mandalId)
        {
            var deleteMandal = APSeedCo_Entity.SCO_Mandal
                .Where(mandal => mandal.Id == mandalId).SingleOrDefault();
            if (deleteMandal != null)
            {
                deleteMandal.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Mandal deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        // ******************************Master Data Related to Location ***************************************
        // Fetch Location Based on DistrictId
        [HttpGet]
        [Route("Master/GetLocationByDistrictId")]

        public HttpResponseMessage GetLocationById(int vdistrictId)
        {
            var LocationListById = APSeedCo_Entity.SCO_Location.Where(location => location.DistrictId == vdistrictId)
                                                                .Select(location => new { location.Id, location.Name }).ToList();
            List<LocationList> vlocation = new List<LocationList>();
            foreach (var sel in LocationListById)
            {
                LocationList locationObj = new LocationList();
                locationObj.Id = sel.Id;
                locationObj.Name = sel.Name;
                vlocation.Add(locationObj);
            }
            if (vlocation != null)
            {
                return Request.CreateResponse<List<LocationList>>(HttpStatusCode.OK, vlocation);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Location not avaliable "),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Fetch Location Details

        [HttpGet]
        [Route("Master/GetLocation")]
        public HttpResponseMessage GetLocation()
        {
            var locationList = APSeedCo_Entity.SCO_Location.ToList();
            if (locationList != null)
            {
                return Request.CreateResponse<List<SCO_Location>>(HttpStatusCode.OK, locationList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Location not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Add Location 
        [HttpPost]
        [Route("Master/Addlocation")]
        public HttpResponseMessage AddingLocation(SCO_Location vlocation)
        {
            if (vlocation != null)
            {
                if (vlocation.Id > 0)
                {
                    SCO_Location LocationFind = APSeedCo_Entity.SCO_Location.Where(location => location.Id == vlocation.Id).FirstOrDefault();
                    if (LocationFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Location is not avaliable with the Id "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        LocationFind.Name = vlocation.Name;
                        LocationFind.DistrictId = vlocation.DistrictId;
                        LocationFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Location updated successfully");
                    }
                }
                else
                {

                    SCO_Location LocationFind = APSeedCo_Entity.SCO_Location.Where(location => location.Name == vlocation.Name).FirstOrDefault();
                    if (LocationFind == null)
                    {
                        SCO_Location locationObj = new SCO_Location();
                        locationObj.DistrictId = vlocation.DistrictId;
                        locationObj.Name = vlocation.Name;
                        locationObj.IsActive = true;
                        APSeedCo_Entity.SCO_Location.Add(locationObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Location created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Location exists with the same name "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Location
        [HttpGet]
        [Route("Master/DeleteLocation")]
        public HttpResponseMessage DeleteLocation(int locationId)
        {
            var deleteLocation = APSeedCo_Entity.SCO_Location
                .Where(location => location.Id == locationId).SingleOrDefault();
            if (deleteLocation != null)
            {
                deleteLocation.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Location deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // ***************************Master data related to Divisions **********************

        // Add Divisions 
        [HttpPost]
        [Route("Master/AddDivision")]
        public HttpResponseMessage AddingDivision(SCO_PR_Division vdivision)
        {
            if (vdivision != null)
            {
                if (vdivision.Id > 0)
                {
                    SCO_PR_Division divisionFind = APSeedCo_Entity.SCO_PR_Division.Where(division => division.Id == vdivision.Id).SingleOrDefault();
                    if (divisionFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Division is not avaliable with the Id "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        divisionFind.Name = vdivision.Name;
                        divisionFind.DistrictId = vdivision.DistrictId;
                        divisionFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Division updated successfully");
                    }
                }
                else
                {
                    SCO_PR_Division divisionFind = APSeedCo_Entity.SCO_PR_Division.Where(division => division.Name == vdivision.Name).FirstOrDefault();

                    if (divisionFind == null)
                    {
                        SCO_PR_Division divisionObj = new SCO_PR_Division();

                        divisionObj.DistrictId = vdivision.DistrictId;
                        divisionObj.Name = vdivision.Name;
                        divisionObj.IsActive = true;
                        APSeedCo_Entity.SCO_PR_Division.Add(divisionObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Division created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Division exists with the same name "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Fetch divisions
        [HttpGet]
        [Route("Master/GetDivisions")]

        public HttpResponseMessage GetDivsions()
        {
            var divisionList = APSeedCo_Entity.SCO_PR_Division.ToList();
            if (divisionList != null)
            {
                return Request.CreateResponse<List<SCO_PR_Division>>(HttpStatusCode.OK, divisionList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Division are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest

                });
            }
        }

        // Delete Location
        [HttpGet]
        [Route("Master/DeleteDivision")]
        public HttpResponseMessage DeleteDivision(int divisionId)
        {
            var deleteDivision = APSeedCo_Entity.SCO_PR_Division
                .Where(division => division.Id == divisionId).SingleOrDefault();
            if (deleteDivision != null)
            {
                deleteDivision.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Division deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Fetch division by districtId

        [HttpGet]
        [Route("Master/DivisionByPR_DistId")]

        public HttpResponseMessage GetDivisionByDistrictId(int vdistrictId)
        {
            var divisionListById = APSeedCo_Entity.SCO_PR_Division.Where(division => division.DistrictId == vdistrictId)
                                                                  .Select(division => new { division.Id, division.Name }).ToList();
            List<DivisionList> vdivision = new List<DivisionList>();
            foreach (var sel in divisionListById)
            {
                DivisionList divisionObj = new DivisionList();
                divisionObj.Id = sel.Id;
                divisionObj.Name = sel.Name;
                vdivision.Add(divisionObj);
            }
            if (vdivision != null)
            {

                return Request.CreateResponse<List<DivisionList>>(HttpStatusCode.OK, vdivision);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Divisions are not avaliable with the districtId"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // ************************** Master data related to PR_Mandals***************************


        // Add PR_Mandals
        [HttpPost]
        [Route("Master/Add_PR_Mandal")]
        public HttpResponseMessage AddingPR_Mandal(SCO_PR_Mandal vpr_Mandal)
        {
            if (vpr_Mandal != null)
            {
                if (vpr_Mandal.Id > 0)
                {
                    SCO_PR_Mandal mandalFind = APSeedCo_Entity.SCO_PR_Mandal.Where(mandal => mandal.Id == vpr_Mandal.Id).FirstOrDefault();
                    if (mandalFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"PR_mandal is not valiable with the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        mandalFind.Name = vpr_Mandal.Name;
                        mandalFind.DivisionId = vpr_Mandal.DivisionId;
                        mandalFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "PR_Mandal updated successfully");
                    }
                }
                else
                {

                    SCO_PR_Mandal mandalFind = APSeedCo_Entity.SCO_PR_Mandal.Where(mandal => mandal.Name == vpr_Mandal.Name).FirstOrDefault();

                    if (mandalFind == null)
                    {
                        SCO_PR_Mandal pr_MandalObj = new SCO_PR_Mandal();


                        pr_MandalObj.DivisionId = vpr_Mandal.DivisionId;
                        pr_MandalObj.Name = vpr_Mandal.Name;
                        pr_MandalObj.IsActive = true;
                        APSeedCo_Entity.SCO_PR_Mandal.Add(pr_MandalObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "PR_mandal created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"PR_mandal exists with the same name "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/GetPR_Mandals")]

        public HttpResponseMessage GetPR_Mandals()
        {
            var PR_mandalList = APSeedCo_Entity.SCO_PR_Mandal.ToList();
            if (PR_mandalList != null)
            {
                return Request.CreateResponse<List<SCO_PR_Mandal>>(HttpStatusCode.OK, PR_mandalList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Mandals are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }

        }
        // Fetch PR_Mandals By Divisions

        [HttpGet]
        [Route("Master/MandalByPR_DivisionId")]

        public HttpResponseMessage GetMandalsByDivisionId(int vdivisionId)
        {
            var PR_mandalListById = APSeedCo_Entity.SCO_PR_Mandal.Where(mandal => mandal.DivisionId == vdivisionId)
                                                                  .Select(mandal => new { mandal.Id, mandal.Name });
            List<PR_MandalList> PR_mandalList = new List<PR_MandalList>();

            foreach (var sel in PR_mandalListById)
            {
                PR_MandalList PR_mandalObj = new PR_MandalList();
                PR_mandalObj.Id = sel.Id;
                PR_mandalObj.Name = sel.Name;
                PR_mandalList.Add(PR_mandalObj);
            }
            if (PR_mandalList != null)
            {
                return Request.CreateResponse<List<PR_MandalList>>(HttpStatusCode.OK, PR_mandalList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Mandals are not avaliable with the divisionId"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        /* Master data related to PR_Villages*/

        [HttpPost]
        [Route("Master/Add_PR_Village")]
        public HttpResponseMessage AddingPR_Village(SCO_PR_Village vpr_Village)
        {
            if (vpr_Village != null)
            {

                if (vpr_Village.Id > 0)
                {
                    SCO_PR_Village villageFind = APSeedCo_Entity.SCO_PR_Village.Where(village => village.Id == vpr_Village.Id).FirstOrDefault();
                    if (villageFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"PR_village is not valiable with the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        villageFind.Name = vpr_Village.Name;
                        villageFind.MandalId = vpr_Village.MandalId;
                        villageFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "PR_Mandal updated successfully");
                    }
                }
                else
                {
                    SCO_PR_Village villageFind = APSeedCo_Entity.SCO_PR_Village.Where(village => village.Name == vpr_Village.Name).FirstOrDefault();

                    if (villageFind == null)
                    {
                        SCO_PR_Village pr_VillageObj = new SCO_PR_Village();


                        pr_VillageObj.MandalId = vpr_Village.MandalId;
                        pr_VillageObj.Name = vpr_Village.Name;
                        pr_VillageObj.IsActive = true;
                        APSeedCo_Entity.SCO_PR_Village.Add(pr_VillageObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "PR_Village created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"PR_Village exists with the same name "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        // Fetch Villages List
        [HttpGet]
        [Route("Master/GetPR_Villages")]

        public HttpResponseMessage GetPR_Villages()
        {
            var PR_villageList = APSeedCo_Entity.SCO_PR_Village.ToList();
            if (PR_villageList != null)
            {
                return Request.CreateResponse<List<SCO_PR_Village>>(HttpStatusCode.OK, PR_villageList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Villages are not avaliable "),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }

        }

        // Delete Location
        [HttpGet]
        [Route("Master/Delete_PR_Mandal")]
        public HttpResponseMessage Delete_PR_Mandal(int PR_Mandal)
        {
            var delete_PR_Mandal = APSeedCo_Entity.SCO_PR_Mandal
                .Where(PR_mandal => PR_mandal.Id == PR_Mandal).SingleOrDefault();
            if (delete_PR_Mandal != null)
            {
                delete_PR_Mandal.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "PR_Mandal deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Fetch PR_Mandals By Divisions

        [HttpGet]
        [Route("Master/VillageByPR_MandalId")]

        public HttpResponseMessage GetVillagesByMandalId(int vmandalId)
        {
            var PR_villagesListById = APSeedCo_Entity.SCO_PR_Village.Where(village => village.MandalId == vmandalId)
                                                                    .Select(village => new { village.Id, village.Name });

            List<PR_VillageList> PR_villageList = new List<PR_VillageList>();
            foreach (var sel in PR_villagesListById)
            {
                PR_VillageList PR_villageObj = new PR_VillageList();
                PR_villageObj.Id = sel.Id;
                PR_villageObj.Name = sel.Name;
                PR_villageList.Add(PR_villageObj);
            }
            if (PR_villageList != null)
            {

                return Request.CreateResponse<List<PR_VillageList>>(HttpStatusCode.OK, PR_villageList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Villages are not avaliable with the MandalId"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/DeletePR_Village")]
        public HttpResponseMessage DeletePR_Village(int villageId)
        {
            var deletePR_Village = APSeedCo_Entity.SCO_PR_Village
                .Where(village => village.Id == villageId).SingleOrDefault();
            if (deletePR_Village != null)
            {
                deletePR_Village.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Village deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Method for Adding Department 
        [HttpPost]
        [Route("Master/AddDepartment")]
        public HttpResponseMessage AddingDepartment(SCO_Department vdept)
        {
            if (vdept != null)
            {
                if (vdept.Id > 0)
                {
                    SCO_Department deptFind = APSeedCo_Entity.SCO_Department
                        .Where(dept => dept.Id == vdept.Id).SingleOrDefault();
                    if (deptFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Departments are not avaliable with the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        deptFind.Name = vdept.Name;
                        deptFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Department updated successfully");
                    }
                }
                else
                {
                    SCO_Department deptFind = APSeedCo_Entity.SCO_Department.Where(dept => dept.Name == vdept.Name).FirstOrDefault();
                    if (deptFind == null)
                    {
                        SCO_Department deptObj = new SCO_Department();
                        deptObj.Name = vdept.Name;
                        deptObj.IsActive = true;
                        APSeedCo_Entity.SCO_Department.Add(deptObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Department created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Department exists with the same name"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }



        // Get Departments
        [HttpGet]
        [Route("Master/GetDepartments")]
        public HttpResponseMessage GetDepartment()
        {
            var departmentList = APSeedCo_Entity.SCO_Department.ToList();
            if (departmentList != null)
            {
                return Request.CreateResponse<List<SCO_Department>>(HttpStatusCode.OK, departmentList);
            }
            else
            {

                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch departments"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/DeleteDepartments")]
        public HttpResponseMessage DeleteDepartments(int deptId)
        {
            var deleteDepartment = APSeedCo_Entity.SCO_Department
                .Where(dept => dept.Id == deptId).SingleOrDefault();
            if (deleteDepartment != null)
            {
                deleteDepartment.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Department deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Method for adding Blocks
        [HttpPost]
        [Route("Master/AddBlocks")]
        public HttpResponseMessage AddBlocks(SCO_Block vblock)
        {
            if (vblock == null)
            {
                if (vblock.Id > 0)
                {
                    SCO_Block blockFind = APSeedCo_Entity.SCO_Block
                        .Where(block => block.Id == vblock.Id).SingleOrDefault();
                    if (blockFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Blocks are not avaliable with the Id "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        blockFind.NumberOfBlock = vblock.NumberOfBlock;
                        blockFind.TypeOfBlock = vblock.TypeOfBlock;
                        blockFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Block updated successfully");
                    }
                }
                else
                {
                    SCO_Block vblockObj = new SCO_Block();
                    vblockObj.NumberOfBlock = vblock.NumberOfBlock;
                    vblockObj.TypeOfBlock = vblock.TypeOfBlock;
                    vblockObj.IsActive = true;
                    APSeedCo_Entity.SCO_Block.Add(vblockObj);
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Blocks created successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/Deleteblock")]
        public HttpResponseMessage DeleteBlock(int blockId)
        {
            var deleteBlock = APSeedCo_Entity.SCO_Block
                .Where(block => block.Id == blockId).SingleOrDefault();
            if (deleteBlock != null)
            {
                deleteBlock.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Block deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get BlockList
        [HttpGet]
        [Route("Master/GetBlocks")]
        public HttpResponseMessage GetBlocks()
        {
            var blockList = APSeedCo_Entity.SCO_Block.ToList();
            if (blockList != null)
            {
                return Request.CreateResponse<List<SCO_Block>>(HttpStatusCode.OK, blockList);
            }
            else
            {

                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch Blocks"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Method for adding Blocks
        [HttpPost]
        [Route("Master/AddFloor")]
        public HttpResponseMessage Addfloor(SCO_Floor vfloor)
        {
            if (vfloor == null)
            {
                if (vfloor.Id > 0)
                {
                    SCO_Floor floorFind = APSeedCo_Entity.SCO_Floor
                        .Where(floor => floor.Id == floor.Id).SingleOrDefault();
                    if (floorFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Floor are not avaliable with the Id "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        floorFind.Floor = vfloor.Floor;
                        floorFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Floor updated successfully");
                    }
                }
                else
                {
                    SCO_Floor floorObj = new SCO_Floor();
                    floorObj.Floor = vfloor.Floor;
                    floorObj.IsActive = true;
                    APSeedCo_Entity.SCO_Floor.Add(floorObj);
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Floor created successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get FloorList
        [HttpGet]
        [Route("Master/GetFloors")]
        public HttpResponseMessage GetFloors()
        {
            var floorList = APSeedCo_Entity.SCO_Floor.ToList();
            if (floorList != null)
            {
                return Request.CreateResponse<List<SCO_Floor>>(HttpStatusCode.OK, floorList);
            }
            else
            {

                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch floors"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/DeleteFloor")]
        public HttpResponseMessage DeleteFloor(int floorId)
        {
            var deleteFloor = APSeedCo_Entity.SCO_Floor
                .Where(floor => floor.Id == floorId).SingleOrDefault();
            if (deleteFloor != null)
            {
                deleteFloor.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Floor deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Method for adding housenumberList
        [HttpPost]
        [Route("Master/SaveHouseNumberList")]
        public HttpResponseMessage SaveHouseNumberList(SCO_HouseNumber vhouseNumber)
        {
            if (vhouseNumber == null)
            {
                if (vhouseNumber.Id > 0)
                {
                    SCO_HouseNumber houseFind = APSeedCo_Entity.SCO_HouseNumber
                        .Where(house => house.Id == house.Id).SingleOrDefault();
                    if (houseFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"HouseNumbers are not avaliable with the Id "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        houseFind.HouseNumber = vhouseNumber.HouseNumber;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "HouseNumber updated successfully");
                    }
                }
                else
                {
                    SCO_HouseNumber vhouseObj = new SCO_HouseNumber();
                    vhouseObj.HouseNumber = vhouseNumber.HouseNumber;
                    APSeedCo_Entity.SCO_HouseNumber.Add(vhouseObj);
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "HouseNumber created successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        // Get HouseNumberList
        [HttpGet]
        [Route("Master/GetHnoList")]
        public HttpResponseMessage GetHouseNumber()
        {
            var hnoList = APSeedCo_Entity.SCO_HouseNumber.ToList();
            if (hnoList != null)
            {
                return Request.CreateResponse<List<SCO_HouseNumber>>(HttpStatusCode.OK, hnoList);
            }
            else
            {

                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch houseNumber"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/DeleteHousenumber")]
        public HttpResponseMessage DeleteHouseNumber(int houseId)
        {
            var deletehouseNumber = APSeedCo_Entity.SCO_HouseNumber
                .Where(house => house.Id == houseId).SingleOrDefault();
            if (deletehouseNumber != null)
            {
                deletehouseNumber.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Housenumber deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Method for adding housenumberList
        [HttpPost]
        [Route("Master/SaveTypeOfSpace")]
        public HttpResponseMessage SaveTypeOfSpace(SCO_TypeOfSpace vspace)
        {
            if (vspace == null)
            {
                if (vspace.Id > 0)
                {
                    SCO_TypeOfSpace spaceFind = APSeedCo_Entity.SCO_TypeOfSpace
                        .Where(space => space.Id == space.Id).SingleOrDefault();
                    if (spaceFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Space is not avaliable with the Id "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        spaceFind.SpaceName = vspace.SpaceName;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Space updated successfully");
                    }
                }
                else
                {
                    SCO_TypeOfSpace spaceObj = new SCO_TypeOfSpace();
                    spaceObj.SpaceName = spaceObj.SpaceName;
                    APSeedCo_Entity.SCO_TypeOfSpace.Add(spaceObj);
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Space created successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get TypeOfSpace
        [HttpGet]
        [Route("Master/GetSpaceList")]
        public HttpResponseMessage GetTypeOfSpace()
        {
            var typeOfSpaceList = APSeedCo_Entity.SCO_TypeOfSpace.ToList();

            if (typeOfSpaceList != null)
            {
                return Request.CreateResponse<List<SCO_TypeOfSpace>>(HttpStatusCode.OK, typeOfSpaceList);

            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch space"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Space

        [HttpGet]
        [Route("Master/DeleteSpace")]
        public HttpResponseMessage DeleteSpace(int spaceId)
        {
            var deleteSpace = APSeedCo_Entity.SCO_TypeOfSpace
                .Where(space => space.Id == spaceId).SingleOrDefault();
            if (deleteSpace != null)
            {
                deleteSpace.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Space deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Save TypeOfAppliances
        [HttpPost]
        [Route("Master/AddTypeOfAppliances")]
        public HttpResponseMessage AddingAppliances(C_SCO_TypeOfAsset vappliances)
        {
            if (vappliances != null)
            {
                if (vappliances.Id > 0)
                {
                    C_SCO_TypeOfAsset applianceFind = APSeedCo_Entity.C_SCO_TypeOfAsset
                        .Where(app => app.Id == vappliances.Id).SingleOrDefault();
                    if (applianceFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Appliances are not avaliable with the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        applianceFind.Name = applianceFind.Name;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Appliance updated successfully");
                    }
                }
                else
                {
                    C_SCO_TypeOfAsset applianceFind = APSeedCo_Entity.C_SCO_TypeOfAsset
                        .Where(app => app.Name == vappliances.Name).FirstOrDefault();
                    if (applianceFind == null)
                    {
                        C_SCO_TypeOfAsset applianceObj = new C_SCO_TypeOfAsset();
                        applianceObj.Name = applianceObj.Name;
                        APSeedCo_Entity.C_SCO_TypeOfAsset.Add(applianceObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Appliances created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Appliance exists with the same name"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get Type Of Appliances
        [HttpGet]
        [Route("Master/GetApplianceList")]
        public HttpResponseMessage GetApplianceList()
        {
            var applianceList = APSeedCo_Entity.C_SCO_TypeOfAsset.ToList();

            if (applianceList != null)
            {
                return Request.CreateResponse<List<C_SCO_TypeOfAsset>>(HttpStatusCode.OK, applianceList);
            }
            else
            {

                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch appliances"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Master/DeleteAppliance")]
        public HttpResponseMessage DeleteAppliance(int applianceId)
        {
            var deleteAppliance = APSeedCo_Entity.C_SCO_TypeOfAsset
                .Where(appliance => appliance.Id == applianceId).SingleOrDefault();
            if (deleteAppliance != null)
            {
                deleteAppliance.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Appliance deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get counts of project,users,Workrequest,Suppliers,agency

        [HttpGet]
        [Route("Master/GetCounts")]
        public HttpResponseMessage GetCount()
        {
            var userCount = APSeedCo_Entity.SCO_User.Where(user => user.IsActive == true).Count();
            var ProjCount = APSeedCo_Entity.SCO_Project.Where(proj => proj.IsActive == true).Count();
            var workRequestCount = APSeedCo_Entity.SCO_WorkRequest.Where(WR => WR.IsActive == true).Count();
            var agencyCount = APSeedCo_Entity.SCO_Agency.Where(agency => agency.IsActive == true).Count();
            var projectAbstractCount = APSeedCo_Entity.SCO_ProjectAbstract.Where(projAbs => projAbs.IsActive == true).Count();
            var indentCount = APSeedCo_Entity.SCO_IndentFulfilment.Where(indent => indent.IsActive == true).Count();
            Count listCount = new Count();
            listCount.UserCount = userCount;
            listCount.ProjectCount = ProjCount;
            listCount.WorkrequestCount = workRequestCount;
            listCount.AgencyCount = agencyCount;
            listCount.ProjectAbstractCount = projectAbstractCount;
            listCount.IndentCount = indentCount;
            List<Count> detailsList = new List<Count>();
            detailsList.Add(listCount);
            if (detailsList != null)
            {
                return Request.CreateResponse<List<Count>>(HttpStatusCode.OK, detailsList);
            }
            else
            {

                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch count"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        // Get Mandal Class

        public class MandalsList
        {
            public long Id { get; set; }
            public Nullable<long> DistrictId { get; set; }
            public string Name { get; set; }
        }
        // Get LocationList

        public class LocationList
        {
            public long Id { get; set; }
            public Nullable<long> DistrictId { get; set; }
            public string Name { get; set; }
        }

        //Get Division List

        public class DivisionList
        {
            public long Id { get; set; }
            public Nullable<long> DistrictId { get; set; }
            public string Name { get; set; }

        }

        // get PR_MandalList

        public class PR_MandalList
        {
            public long Id { get; set; }
            public Nullable<long> DivisionId { get; set; }
            public string Name { get; set; }

        }

        //Get PR_VillagesList

        public class PR_VillageList
        {
            public long Id { get; set; }
            public Nullable<long> MandalId { get; set; }
            public string Name { get; set; }

        }
    }

    public class Count
    {
        public int UserCount { get; set; }
        public int ProjectCount { get; set; }
        public int WorkrequestCount { get; set; }
        public int AgencyCount { get; set; }
        public int IndentCount { get; set; }
        public int ProjectAbstractCount { get; set; }
    }
}