﻿using APSEED_SCO.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class ProjectController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();

        // Save project

        [HttpPost]
        [Route("Project/SaveProject")]
        public HttpResponseMessage SaveProject(SCO_Project vproject)
        {
            if (vproject != null)
            {
                if (vproject.Id > 0)
                {
                    SCO_Project projectId = APSeedCo_Entity.SCO_Project
                        .Where(proj => proj.Id == vproject.Id).SingleOrDefault();
                    if (projectId == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {

                            Content = new StringContent($"Project does not exists with this id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        projectId.ProjectName = vproject.ProjectName;
                        projectId.Description = vproject.Description;
                        projectId.DepartmentId = vproject.DepartmentId;
                        projectId.DistrictId = vproject.DistrictId;
                        projectId.MandalId = vproject.MandalId;
                        projectId.LocationId = vproject.LocationId;
                        projectId.PR_DivisionId = vproject.PR_DivisionId;
                        projectId.PR_MandalId = vproject.PR_MandalId;
                        projectId.PR_VillageId = vproject.PR_VillageId;
                        projectId.BlockId = vproject.BlockId;
                        projectId.HouseId = vproject.HouseId;
                        projectId.FloorId = vproject.FloorId;
                        projectId.CreatedBy = vproject.CreatedBy;
                        projectId.ModifiedBy = vproject.ModifiedBy;
                        projectId.ModifiedDate = DateTime.Now;
                        projectId.EndDate = vproject.EndDate;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Project updated successfully");
                    }
                }
                else
                {
                    SCO_Project projectFind = APSeedCo_Entity.SCO_Project
                        .Where(proj => proj.ProjectName == vproject.ProjectName).SingleOrDefault();
                    if (projectFind == null)
                    {
                        SCO_Project projectObj = new SCO_Project();
                        long projectIdCount = Convert.ToInt64(APSeedCo_Entity.SCO_Project
                            .Max(c => (long?)c.Id));
                        if (projectIdCount == 0)
                        {
                            projectIdCount = 1;
                        }
                        else
                        {
                            projectIdCount = projectIdCount + 1;
                        }

                        projectObj.ProjectId = "Proj-" + projectIdCount.ToString();
                        projectObj.ProjectName = vproject.ProjectName;
                        projectObj.Description = vproject.Description;
                        projectObj.DepartmentId = vproject.DepartmentId;
                        projectObj.StartDate = DateTime.Now;
                        projectObj.DistrictId = vproject.DistrictId;
                        projectObj.MandalId = vproject.MandalId;
                        projectObj.LocationId = vproject.LocationId;
                        projectObj.PR_DivisionId = vproject.PR_DivisionId;
                        projectObj.PR_MandalId = vproject.PR_MandalId;
                        projectObj.PR_VillageId = vproject.PR_VillageId;
                        projectObj.BlockId = vproject.BlockId;
                        projectObj.HouseId = vproject.HouseId;
                        projectObj.FloorId = vproject.FloorId;
                        projectObj.CreatedDate = DateTime.Now;
                        projectObj.CreatedBy = vproject.CreatedBy;
                        projectObj.ModifiedBy = vproject.ModifiedBy;
                        projectObj.ModifiedDate = DateTime.Now;
                        projectObj.StartDate = vproject.StartDate;
                        projectObj.EndDate = vproject.EndDate;
                        projectObj.IsActive = true;
                        APSeedCo_Entity.SCO_Project.Add(projectObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Project created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Project  exists with the same Name"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Fetching ProjectList based on Departments and Districts

        [HttpGet]
        [Route("Project/ProjectListByDeptAndDist")]
        public HttpResponseMessage GetProjectlist(int deptId, int distId)
        {
            var projectList = APSeedCo_Entity.SCO_Project.Include("SCO_District")
                .Include("SCO_Department").Include("SCO_Mandal")
                .Include("SCO_Location").Include("SCO_PR_Division").Include("SCO_PR_Mandal")
                .Include("SCO_PR_Village").Include("SCO_Floor").Include("SCO_Block")
                .Include("SCO_HouseNumber")
                .Where(proj => proj.DepartmentId == deptId && proj.DistrictId == distId && proj.IsActive == true).ToList();
            List<ProjectList> projectData = new List<ProjectList>();
            foreach (var vsel in projectList)
            {
                ProjectList projectObj = new ProjectList();
                projectObj.Id = vsel.Id;
                projectObj.ProjectName = vsel.ProjectName;
                projectObj.ProjectId = vsel.ProjectId;
                projectObj.DistrictId = vsel.DistrictId;
                projectObj.IsActive = vsel.IsActive;
                projectObj.CreatedBy = vsel.CreatedBy;
                projectObj.CreatedDate = vsel.CreatedDate;
                projectObj.ModifiedBy = vsel.ModifiedBy;
                projectObj.ModifiedDate = vsel.ModifiedDate;
                if (vsel.SCO_District == null)
                {
                    projectObj.DistrictName = null;
                }
                else
                {
                    projectObj.DistrictName = vsel.SCO_District.Name;
                }
                projectObj.DepartmentId = vsel.DepartmentId;
                if (vsel.SCO_Department == null)
                {
                    projectObj.DepartmentName = null;
                }
                else
                {
                    projectObj.DepartmentName = vsel.SCO_Department.Name;
                }
                projectObj.MandalId = vsel.MandalId;
                projectObj.FloorId = vsel.FloorId;
                if (vsel.SCO_Floor == null)
                {
                    projectObj.FloorName = null;
                }
                else
                {
                    projectObj.FloorName = vsel.SCO_Floor.Floor;
                }
                projectObj.HouseId = vsel.HouseId;
                if (vsel.SCO_HouseNumber == null)
                {
                    projectObj.HouseName = null;
                }
                else
                {
                    projectObj.HouseName = vsel.SCO_HouseNumber.HouseNumber;
                }
                projectObj.BlockId = vsel.BlockId;
                if (vsel.SCO_Block == null)
                {
                    projectObj.BlockName = null;
                }
                else
                {
                    projectObj.BlockName = vsel.SCO_Block.NumberOfBlock;
                }
                projectObj.Description = vsel.Description;
                if (vsel.SCO_Mandal == null)
                {
                    projectObj.MandalName = null;
                }
                else
                {
                    projectObj.MandalName = vsel.SCO_Mandal.Name;
                }
                projectObj.LocationId = vsel.LocationId;
                if (vsel.SCO_Location == null)
                {
                    projectObj.LocationName = null;
                }
                else
                {
                    projectObj.LocationName = vsel.SCO_Location.Name;
                }
                projectObj.PR_DivisionId = vsel.PR_DivisionId;
                if (vsel.SCO_PR_Division == null)
                {
                    projectObj.PR_DivisionName = null;
                }
                else
                {
                    projectObj.PR_DivisionName = vsel.SCO_PR_Division.Name;
                }
                projectObj.PR_MandalId = vsel.PR_MandalId;
                if (vsel.SCO_PR_Mandal == null)
                {
                    projectObj.PR_MandalName = null;
                }
                else
                {
                    projectObj.PR_MandalName = vsel.SCO_PR_Mandal.Name;
                }
                projectObj.PR_VillageId = vsel.PR_VillageId;
                if (vsel.SCO_PR_Village == null)
                {
                    projectObj.PR_VillageName = null;
                }
                else
                {
                    projectObj.PR_VillageName = vsel.SCO_PR_Village.Name;
                }
                projectData.Add(projectObj);
            }
            if (projectData != null)
            {
                return Request.CreateResponse<List<ProjectList>>(HttpStatusCode.OK, projectData);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Projects are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get Districts based on DepartmentId

        [HttpGet]
        [Route("Project/GetDistrictsByDeptId")]
        public HttpResponseMessage GetDistrictsBydeptId(int deptId)
        {
            var projectDetails = APSeedCo_Entity.SCO_Project
                .Where(proj => proj.DepartmentId == deptId).ToList().Select(d => d.DistrictId).Distinct();
            List<ProjectList> dislist = new List<ProjectList>();

            foreach (var distId in projectDetails)
            {
                var distDetails = APSeedCo_Entity.SCO_District.Where(d => d.Id == distId).SingleOrDefault();
                ProjectList list = new ProjectList();
                list.DistrictId = distDetails.Id;
                list.DistrictName = distDetails.Name;
                dislist.Add(list);
            }

            if (dislist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, dislist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Districts are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }

        }
        // Get  ProjectsList

        [HttpGet]
        [Route("Project/GetProjectList")]
        public HttpResponseMessage GetAllProjectlist()
        {
            var projectList = APSeedCo_Entity.SCO_Project.Include("SCO_District")
                .Include("SCO_Department").Include("SCO_Mandal")
                .Include("SCO_Location").Include("SCO_PR_Division").Include("SCO_PR_Mandal")
                .Include("SCO_PR_Village").Include("SCO_Floor").Include("SCO_Block")
                .Include("SCO_HouseNumber").Where(proj => proj.IsActive == true).ToList();
            List<ProjectList> projectData = new List<ProjectList>();
            foreach (var vsel in projectList)
            {
                ProjectList projectObj = new ProjectList();
                projectObj.Id = vsel.Id;
                projectObj.ProjectName = vsel.ProjectName;
                projectObj.ProjectId = vsel.ProjectId;
                projectObj.DistrictId = vsel.DistrictId;
                projectObj.IsActive = vsel.IsActive;
                projectObj.CreatedBy = vsel.CreatedBy;
                projectObj.CreatedDate = vsel.CreatedDate;
                projectObj.ModifiedBy = vsel.ModifiedBy;
                projectObj.ModifiedDate = vsel.ModifiedDate;
                if (vsel.SCO_District == null)
                {
                    projectObj.DistrictName = null;
                }
                else
                {
                    projectObj.DistrictName = vsel.SCO_District.Name;
                }
                projectObj.DepartmentId = vsel.DepartmentId;
                if (vsel.SCO_Department == null)
                {
                    projectObj.DepartmentName = null;
                }
                else
                {
                    projectObj.DepartmentName = vsel.SCO_Department.Name;
                }
                projectObj.MandalId = vsel.MandalId;
                projectObj.FloorId = vsel.FloorId;
                if (vsel.SCO_Floor == null)
                {
                    projectObj.FloorName = null;
                }
                else
                {
                    projectObj.FloorName = vsel.SCO_Floor.Floor;
                }
                projectObj.HouseId = vsel.HouseId;
                if (vsel.SCO_HouseNumber == null)
                {
                    projectObj.HouseName = null;
                }
                else
                {
                    projectObj.HouseName = vsel.SCO_HouseNumber.HouseNumber;
                }
                projectObj.BlockId = vsel.BlockId;
                if (vsel.SCO_Block == null)
                {
                    projectObj.BlockName = null;
                }
                else
                {
                    projectObj.BlockName = vsel.SCO_Block.NumberOfBlock;
                }
                projectObj.Description = vsel.Description;
                if (vsel.SCO_Mandal == null)
                {
                    projectObj.MandalName = null;
                }
                else
                {
                    projectObj.MandalName = vsel.SCO_Mandal.Name;
                }
                projectObj.LocationId = vsel.LocationId;
                if (vsel.SCO_Location == null)
                {
                    projectObj.LocationName = null;
                }
                else
                {
                    projectObj.LocationName = vsel.SCO_Location.Name;
                }
                projectObj.PR_DivisionId = vsel.PR_DivisionId;
                if (vsel.SCO_PR_Division == null)
                {
                    projectObj.PR_DivisionName = null;
                }
                else
                {
                    projectObj.PR_DivisionName = vsel.SCO_PR_Division.Name;
                }
                projectObj.PR_MandalId = vsel.PR_MandalId;
                if (vsel.SCO_PR_Mandal == null)
                {
                    projectObj.PR_MandalName = null;
                }
                else
                {
                    projectObj.PR_MandalName = vsel.SCO_PR_Mandal.Name;
                }
                projectObj.PR_VillageId = vsel.PR_VillageId;
                if (vsel.SCO_PR_Village == null)
                {
                    projectObj.PR_VillageName = null;
                }
                else
                {
                    projectObj.PR_VillageName = vsel.SCO_PR_Village.Name;
                }
                projectData.Add(projectObj);
            }
            if (projectData != null)
            {
                return Request.CreateResponse<List<ProjectList>>(HttpStatusCode.OK, projectData);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Projects  are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Project 

        [HttpGet]
        [Route("Project/DeleteProject")]
        public HttpResponseMessage DeleteProject(int projId)
        {
            var projectFind = APSeedCo_Entity.SCO_Project
                .Where(proj => proj.Id == projId && proj.IsActive == true).SingleOrDefault();

            if (projectFind != null)
            {
                var WrFindall = APSeedCo_Entity.SCO_WorkRequest
                 .Where(WR => WR.ProjectId == projId).FirstOrDefault();
                if (WrFindall == null)
                {
                    projectFind.IsActive = false;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Project deleted successfully");
                }
                else
                {
                    var WrFind = APSeedCo_Entity.SCO_WorkRequest
                .Where(WR => WR.ProjectId == projId && WR.IsActive == true).FirstOrDefault();
                    var ProjAbsFind = APSeedCo_Entity.SCO_ProjectAbstract
                         .Where(projAbs => projAbs.ProjectId == projId && projAbs.IsActive == true).FirstOrDefault();
                    var IndentFind = APSeedCo_Entity.SCO_IndentFulfilment
                         .Where(indent => indent.ProjectId == projId && indent.IsActive == true).FirstOrDefault();
                    if (WrFind == null && ProjAbsFind == null && IndentFind == null)
                    {
                        projectFind.IsActive = false;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Project disabled successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"The project is in progress, So cannot disable"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"No project available with this name."),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // List of Disabled projects By DepartmentId and DistrictId
        [HttpGet]
        [Route("Project/DisabledProjectListByDeptAndDist")]
        public HttpResponseMessage GetDisabledProjectlist(int deptId, int distId)
        {
            var projectList = APSeedCo_Entity.SCO_Project.Include("SCO_District")
                .Include("SCO_Department")
                .Where(proj => proj.DepartmentId == deptId && proj.DistrictId == distId && proj.IsActive == false).ToList();
            List<ProjectList> projectData = new List<ProjectList>();
            foreach (var vsel in projectList)
            {
                ProjectList projectObj = new ProjectList();
                projectObj.Id = vsel.Id;
                projectObj.ProjectName = vsel.ProjectName;
                projectObj.ProjectId = vsel.ProjectId;
                projectObj.DistrictId = vsel.DistrictId;
                projectObj.IsActive = vsel.IsActive;
                if (vsel.SCO_District == null)
                {
                    projectObj.DistrictName = null;
                }
                else
                {
                    projectObj.DistrictName = vsel.SCO_District.Name;
                }
                projectObj.DepartmentId = vsel.DepartmentId;
                if (vsel.SCO_Department == null)
                {
                    projectObj.DepartmentName = null;
                }
                else
                {
                    projectObj.DepartmentName = vsel.SCO_Department.Name;
                }
                projectData.Add(projectObj);
            }
            if (projectData != null)
            {
                return Request.CreateResponse<List<ProjectList>>(HttpStatusCode.OK, projectData);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Projects  are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Enable or disable projects By ProjectId and Status
        [HttpGet]
        [Route("Project/EnabledOrDisableProject")]
        public HttpResponseMessage EnabledOrDisabledproject(int projectId, bool status)
        {
            var projectFind = APSeedCo_Entity.SCO_Project.Where(proj => proj.Id == projectId).SingleOrDefault();
            if (projectFind != null)
            {
                if (status == true)
                {
                    projectFind.IsActive = false;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Project disabled successfully");
                }
                else
                {
                    projectFind.IsActive = true;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "project Enabled successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"project does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Save projectAbstract 
        [HttpPost]
        [Route("Project/CreateProjectAbstract")]
        public HttpResponseMessage CreateProjectAbstract(long wrId)
        {
            if (wrId != 0)
            {
                List<SCO_WorkRequestFulfilment> wrFList = APSeedCo_Entity.SCO_WorkRequestFulfilment.Where(c => c.WRId == wrId && c.IsActive == true).ToList();
                if (wrFList != null)
                {
                    foreach (var projAbs in wrFList)
                    {
                        var projAbsDetails = APSeedCo_Entity.SCO_ProjectAbstract.Where(d => d.WRId == wrId && d.AssetId == projAbs.AssetId && d.IsActive == true).SingleOrDefault();

                        if (projAbsDetails != null)
                        {
                            projAbsDetails.WRId = projAbs.WRId;
                            var wrDetails = APSeedCo_Entity.SCO_WorkRequest
                                .Where(wr => wr.Id == projAbsDetails.WRId).SingleOrDefault();
                            projAbsDetails.ProjectId = wrDetails.ProjectId;
                            projAbsDetails.Description = projAbs.Description;
                            projAbsDetails.AssignedTo = null;
                            projAbsDetails.CreatedDate = DateTime.Now;
                            projAbsDetails.ModifiedDate = null;
                            projAbsDetails.AssetTypeId = projAbs.AssetTypeId;
                            projAbsDetails.AgencyId = null;
                            projAbsDetails.ValidUntil = null;
                            projAbsDetails.ValidFrom = null;
                            projAbsDetails.InstallType = wrDetails.RequestType;
                            projAbsDetails.NotificationStatus = "False";
                            projAbsDetails.IsActive = true;
                            projAbsDetails.AssetId = projAbs.AssetId;
                            var assetDetails = APSeedCo_Entity.SCO_Assets
                               .Where(asset => asset.Id == projAbsDetails.AssetId).SingleOrDefault();
                            projAbsDetails.AssetQuantity = Convert.ToInt64(projAbs.AssetQuantity);
                            projAbsDetails.AssetCostPerUnit = assetDetails.PricePerUnit;
                            projAbsDetails.TotalAmount = projAbsDetails.AssetQuantity * projAbsDetails.AssetCostPerUnit;
                            APSeedCo_Entity.SaveChanges();
                        }
                        else
                        {
                            SCO_ProjectAbstract projObj = new SCO_ProjectAbstract();
                            projObj.WRId = projAbs.WRId;
                            var wrDetails = APSeedCo_Entity.SCO_WorkRequest.Include("SCO_User")
                                .Where(wr => wr.Id == projObj.WRId).SingleOrDefault();
                            projObj.ProjectId = wrDetails.ProjectId;
                            projObj.Description = projAbs.Description;
                            projObj.AssignedTo = null;
                            projObj.CreatedDate = DateTime.Now;
                            projObj.ModifiedDate = null;
                            projObj.AssetTypeId = projAbs.AssetTypeId;
                            projObj.AgencyId = null;
                            projObj.ValidUntil = null;
                            projObj.ValidFrom = null;
                            projObj.InstallType = wrDetails.RequestType;
                            projObj.NotificationStatus = "False";
                            projObj.IsActive = true;
                            projObj.CreatedBy = wrDetails.CreatedBy;
                            projObj.AssetId = projAbs.AssetId;
                            var assetDetails = APSeedCo_Entity.SCO_Assets
                               .Where(asset => asset.Id == projObj.AssetId).SingleOrDefault();
                            projObj.AssetQuantity = Convert.ToInt64(projAbs.AssetQuantity);
                            projObj.AssetCostPerUnit = assetDetails.PricePerUnit;
                            projObj.TotalAmount = projObj.AssetQuantity * projObj.AssetCostPerUnit;
                            APSeedCo_Entity.SCO_ProjectAbstract.Add(projObj);
                            APSeedCo_Entity.SaveChanges();
                        }
                    }
                    WorkRequestController wrObj = new WorkRequestController();
                    wrObj.DeleteWork(Convert.ToInt64(wrId));
                    return Request.CreateResponse(HttpStatusCode.OK, "ProjectAbstract created successfully");
                }
                else
                {
                    throw new HttpResponseException(new HttpResponseMessage
                    {
                        Content = new StringContent($"No workrequest created"),
                        StatusCode = HttpStatusCode.BadRequest
                    });
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Update ProjectAbstract
        [HttpPost]
        [Route("Project/UpdateProjectAbstract")]
        public HttpResponseMessage UpdateProjectAbstract(SCO_ProjectAbstract vprojAbstract)
        {
            if (vprojAbstract.Id > 0)
            {
                var projAbstract = APSeedCo_Entity.SCO_ProjectAbstract
                    .Where(projAbs => projAbs.Id == vprojAbstract.Id).SingleOrDefault();
                if (projAbstract == null)
                {
                    throw new HttpResponseException(new HttpResponseMessage
                    {
                        Content = new StringContent($"Project not avaliable with the projectId"),
                        StatusCode = HttpStatusCode.BadRequest
                    });
                }
                else
                {
                    var inventoryDetails = APSeedCo_Entity.SCO_Inventory
                  .Where(inv => inv.AssetId == vprojAbstract.AssetId)
                  .GroupBy(inv1 => inv1.AssetId)
                  .Select(details => new
                  {
                      details.Key,
                      totalAssetQuantity = details.Sum(inv2 => inv2.AssetQuantity)
                  }).SingleOrDefault();
                    if (inventoryDetails == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"No asset avaliable in inventory"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else if (inventoryDetails.totalAssetQuantity < projAbstract.AssetQuantity)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($" Required Asset quantity is greater than  avaliable asset quantity"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        projAbstract.Description = vprojAbstract.Description;
                        projAbstract.AssignedTo = vprojAbstract.AssignedTo;
                        projAbstract.AgencyId = vprojAbstract.AgencyId;
                        projAbstract.CreatedBy = vprojAbstract.CreatedBy;
                        projAbstract.ValidFrom = vprojAbstract.ValidFrom;
                        projAbstract.WRId = vprojAbstract.WRId;
                        projAbstract.AssetTypeId = vprojAbstract.AssetTypeId;
                        projAbstract.ValidUntil = vprojAbstract.ValidUntil;
                        projAbstract.ModifiedDate = DateTime.Now;
                        projAbstract.NotificationStatus = vprojAbstract.NotificationStatus;
                        projAbstract.IsActive = true;
                        APSeedCo_Entity.SaveChanges();

                        IndentController indObj = new IndentController();
                        indObj.SaveIndent(projAbstract);
                        var inventoryCheck = APSeedCo_Entity.SCO_Inventory.Where(ind => ind.WrId == projAbstract.WRId && ind.AssetId == projAbstract.AssetId).SingleOrDefault();
                        if (inventoryCheck == null)
                        {
                            SCO_Inventory inventory_new = new SCO_Inventory();
                            inventory_new.AssetId = projAbstract.AssetId;
                            var assetDetails = APSeedCo_Entity.SCO_Assets
                                  .Where(asset => asset.Id == inventory_new.AssetId).SingleOrDefault();
                            inventory_new.Name = assetDetails.Name;
                            inventory_new.WrId = projAbstract.WRId;
                            inventory_new.AssetQuantity = -projAbstract.AssetQuantity;
                            inventory_new.FaultQuantity = 0;
                            inventory_new.IsActive = false;
                            inventory_new.IsVerified = false;
                            inventory_new.CreatedDate = DateTime.Now;
                            APSeedCo_Entity.SCO_Inventory.Add(inventory_new);
                            APSeedCo_Entity.SaveChanges();
                        }
                        return Request.CreateResponse(HttpStatusCode.OK, "ProjectAbstract updated successfully");
                    }                  
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Getting Project from projectAbstract
        [HttpGet]
        [Route("Project/GetProjectsOfProjAbstarct")]
        public HttpResponseMessage GetProjectsOfProjAbstarct()
        {
            var projectDetails = APSeedCo_Entity.SCO_ProjectAbstract
                .Where(proj => proj.IsActive == true).ToList().Select(projAbs => projAbs.ProjectId).Distinct();
            List<ProjectAbstractList> projAbslist = new List<ProjectAbstractList>();

            foreach (var projId in projectDetails)
            {
                var projDetails = APSeedCo_Entity.SCO_Project.Where(d => d.Id == projId).SingleOrDefault();
                ProjectAbstractList list = new ProjectAbstractList();
                list.Id = projDetails.Id;
                list.ProjectName = projDetails.ProjectName;
                projAbslist.Add(list);
            }

            if (projAbslist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, projAbslist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Projects are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Getting Project from projectAbstract
        [HttpGet]
        [Route("Project/GetProjectsOfProjAbstarctReports")]
        public HttpResponseMessage GetProjectsOfProjAbstarctReports()
        {
            var projectDetails = APSeedCo_Entity.SCO_ProjectAbstract
                .Where(proj =>proj.AssignedTo==null &&proj.AgencyId==null && proj.IsActive == true).ToList().Select(projAbs => projAbs.ProjectId).Distinct();
            List<ProjectAbstractList> projAbslist = new List<ProjectAbstractList>();

            foreach (var projId in projectDetails)
            {
                var projDetails = APSeedCo_Entity.SCO_Project.Where(d => d.Id == projId).SingleOrDefault();
                ProjectAbstractList list = new ProjectAbstractList();
                list.Id = projDetails.Id;
                list.ProjectName = projDetails.ProjectName;
                projAbslist.Add(list);
            }

            if (projAbslist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, projAbslist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Projects are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get ProjectAbstract details by ProjectId
        [HttpGet]
        [Route("Project/GetProjectAbstractDetailsByProjectId")]
        public HttpResponseMessage GetProjectAbstractDetailsByProjectId(int projectId)
        {
            var getProjectAbstractList = APSeedCo_Entity.SCO_ProjectAbstract
                .Include("SCO_Assets")
                .Where(projAbs => projAbs.ProjectId == projectId && projAbs.IsActive == true).ToList();
            List<ProjectAbstractList> projectList = new List<ProjectAbstractList>();
            foreach (var sel in getProjectAbstractList)
            {
                ProjectAbstractList vprojObj = new ProjectAbstractList();
                vprojObj.Id = sel.Id;
                vprojObj.WRId = sel.WRId;
                vprojObj.AssetId = sel.AssetId;
                if (sel.SCO_Assets == null)
                {
                    vprojObj.AssetName = null;
                }
                else
                {
                    vprojObj.AssetName = sel.SCO_Assets.Name;
                    vprojObj.AssetCostPerUnit = sel.SCO_Assets.PricePerUnit;
                }
                vprojObj.AgencyId = sel.AgencyId;
                if (vprojObj.AgencyId == null)
                {
                    vprojObj.AgencyName = null;
                }
                else
                {
                    var agencyDetails = APSeedCo_Entity.SCO_Agency.Where(agency => agency.Id == vprojObj.AgencyId).SingleOrDefault();
                    vprojObj.AgencyName = agencyDetails.AgencyName;
                }
                vprojObj.ProjectId = sel.ProjectId;
                if (vprojObj.ProjectId == 0)
                {
                    vprojObj.ProjectName = null;
                }
                else
                {
                    var projDetails = APSeedCo_Entity.SCO_Project.
                  Where(proj => proj.Id == vprojObj.ProjectId).SingleOrDefault();
                    vprojObj.ProjectName = projDetails.ProjectName;
                }
                vprojObj.Description = sel.Description;
                vprojObj.AssignedTo = Convert.ToInt64(sel.AssignedTo);
                if (vprojObj.AssignedTo == 0)
                {
                    vprojObj.UserName = null;
                }
                else
                {
                    var userDetails = APSeedCo_Entity.SCO_User.Where(user => user.Id == vprojObj.AssignedTo).SingleOrDefault();
                    vprojObj.UserName = userDetails.FirstName + userDetails.LastName;

                }

                vprojObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                if (vprojObj.AssetTypeId == 0)
                {
                    vprojObj.AssetTypeName = null;
                }
                else
                {
                    vprojObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                    var assetTypedetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == vprojObj.AssetTypeId).SingleOrDefault();
                    vprojObj.AssetTypeName = assetTypedetails.Name;
                }
                vprojObj.AssetQuantity = sel.AssetQuantity;
                var inventoryDetails = APSeedCo_Entity.SCO_Inventory
                  .Where(inv => inv.AssetId == vprojObj.AssetId)
                  .GroupBy(inv1 => inv1.AssetId)
                  .Select(details => new
                  {
                      details.Key,
                      totalAssetQuantity = details.Sum(inv2 => inv2.AssetQuantity)
                  }).SingleOrDefault();
                if (inventoryDetails == null)
                {
                    vprojObj.AvaliableAssets = 0;
                }
                else
                {
                    vprojObj.AvaliableAssets = inventoryDetails.totalAssetQuantity;
                }
                vprojObj.CreatedBy = sel.CreatedBy;
                vprojObj.ValidUntil = sel.ValidUntil;
                vprojObj.ValidFrom = sel.ValidFrom;
                vprojObj.ModifiedDate = sel.ModifiedDate;
                vprojObj.RequestType = sel.InstallType;
                vprojObj.NotificationStatus = sel.NotificationStatus;
                vprojObj.TotalAmount = sel.TotalAmount;
                vprojObj.IsActive = sel.IsActive;
                projectList.Add(vprojObj);
            }
            if (projectList != null)
            {
                return Request.CreateResponse<List<ProjectAbstractList>>(HttpStatusCode.OK, projectList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get ProjectAbstract List based on  WRId
        [HttpGet]
        [Route("Project/GetProjectAbstractDetailsById")]
        public HttpResponseMessage GetProjectAbstractDetailsById(int WRId)
        {
            var getProjectAbstractList = APSeedCo_Entity.SCO_ProjectAbstract.Include("SCO_Assets").Include("SCO_Agency")
                .Where(ProjAbs => ProjAbs.WRId == WRId && ProjAbs.IsActive == true).ToList();
            List<ProjectAbstractList> projectList = new List<ProjectAbstractList>();
            foreach (var sel in getProjectAbstractList)
            {
                ProjectAbstractList vprojObj = new ProjectAbstractList();
                vprojObj.Id = sel.Id;
                vprojObj.WRId = sel.WRId;
                vprojObj.AssetId = sel.AssetId;
                if (sel.SCO_Assets == null)
                {
                    vprojObj.AssetName = null;
                }
                else
                {
                    vprojObj.AssetName = sel.SCO_Assets.Name;
                    vprojObj.AssetCostPerUnit = sel.SCO_Assets.PricePerUnit;
                }
                vprojObj.AgencyId = sel.AgencyId;
                if (sel.SCO_Agency == null)
                {
                    vprojObj.AgencyName = null;
                }
                else
                {
                    vprojObj.AgencyName = sel.SCO_Agency.AgencyName;
                }
                vprojObj.ProjectId = sel.ProjectId;
                if (vprojObj.ProjectId == 0)
                {
                    vprojObj.ProjectName = null;
                }
                else
                {
                    var projDetails = APSeedCo_Entity.SCO_Project.
                  Where(proj => proj.Id == vprojObj.ProjectId).SingleOrDefault();
                    vprojObj.ProjectName = projDetails.ProjectName;
                }
                vprojObj.Description = sel.Description;
                vprojObj.AssignedTo = Convert.ToInt64(sel.AssignedTo);
                if (vprojObj.AssignedTo == 0)
                {
                    vprojObj.UserName = null;
                }
                else
                {
                    var userDetails = APSeedCo_Entity.SCO_User
                        .Where(user => user.Id == vprojObj.AssignedTo).SingleOrDefault();
                    vprojObj.UserName = userDetails.FirstName + userDetails.LastName;
                }
                vprojObj.AssetQuantity = sel.AssetQuantity;
                var inventoryDetails = APSeedCo_Entity.SCO_Inventory
                    .Where(inv => inv.AssetId == vprojObj.AssetId)
                    .GroupBy(inv1 => inv1.AssetId)
                    .Select(details => new
                    {
                        details.Key,
                        totalAssetQuantity = details.Sum(inv2 => inv2.AssetQuantity)
                    }).ToList();
                if (inventoryDetails == null)
                {
                    vprojObj.AvaliableAssets = 0;
                }
                else
                {
                    foreach(var vsel in inventoryDetails)
                    {
                        vprojObj.AvaliableAssets = vsel.totalAssetQuantity;
                    }
                   
                }
                vprojObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                if (vprojObj.AssetTypeId == 0)
                {
                    vprojObj.AssetTypeName = null;
                }
                else
                {
                    vprojObj.AssetTypeId = Convert.ToInt64(sel.AssetTypeId);
                    var assetTypedetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == vprojObj.AssetTypeId).SingleOrDefault();
                    vprojObj.AssetTypeName = assetTypedetails.Name;
                }

                vprojObj.CreatedBy = sel.CreatedBy;
                vprojObj.ValidUntil = sel.ValidUntil;
                vprojObj.ValidFrom = sel.ValidFrom;
                vprojObj.RequestType = sel.InstallType;
                vprojObj.NotificationStatus = sel.NotificationStatus;
                vprojObj.TotalAmount = sel.TotalAmount;
                projectList.Add(vprojObj);
            }
            if (projectList != null)
            {
                return Request.CreateResponse<List<ProjectAbstractList>>(HttpStatusCode.OK, projectList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Class related to projectAbstarct
        public class ProjectAbstractList
        {
            public long Id { get; set; }
            public Nullable<long> WRId { get; set; }
            public Nullable<long> ProjectId { get; set; }
            public string ProjectName { get; set; }
            public Nullable<long> AssetId { get; set; }
            public string AgencyName { get; set; }
            public long AssetTypeId { get; set; }
            public string AssetTypeName { get; set; }
            public string Description { get; set; }
            public long AssignedTo { get; set; }
            public string IndentStatus { get; set; }
            public string AssetName { get; set; }
            public long AvaliableAssets { get; set; }
            public string UserName { get; set; }
            public Nullable<long> AgencyId { get; set; }
            public Nullable<System.DateTime> ValidFrom { get; set; }
            public Nullable<System.DateTime> ValidUntil { get; set; }
            public Nullable<long> AssetQuantity { get; set; }
            public Nullable<decimal> AssetCostPerUnit { get; set; }
            public string RequestType { get; set; }
            public string NotificationStatus { get; set; }
            public Nullable<System.DateTime> CreatedDate { get; set; }
            public string CreatedBy { get; set; }
            public Nullable<System.DateTime> ModifiedDate { get; set; }
            public bool IsActive { get; set; }
            public Nullable<decimal> TotalAmount { get; set; }
        }

        //  project List class
        public class ProjectList
        {
            public long Id { get; set; }
            public string ProjectName { get; set; }
            public string ProjectId { get; set; }
            public Nullable<long> DepartmentId { get; set; }
            public Nullable<long> DistrictId { get; set; }
            public Nullable<long> MandalId { get; set; }
            public Nullable<long> LocationId { get; set; }
            public Nullable<long> PR_DivisionId { get; set; }
            public Nullable<long> PR_MandalId { get; set; }
            public Nullable<long> PR_VillageId { get; set; }
            public string Description { get; set; }
            public string DepartmentName { get; set; }
            public string DistrictName { get; set; }
            public string MandalName { get; set; }
            public string LocationName { get; set; }
            public string PR_DivisionName { get; set; }
            public string PR_MandalName { get; set; }
            public string PR_VillageName { get; set; }
            public Nullable<long> BlockId { get; set; }
            public Nullable<long> HouseId { get; set; }
            public Nullable<long> FloorId { get; set; }
            public string CreatedBy { get; set; }
            public string BlockName { get; set; }
            public string FloorName { get; set; }
            public string HouseName { get; set; }
            public bool IsActive { get; set; }
            public Nullable<System.DateTime> CreatedDate { get; set; }
            public string ModifiedBy { get; set; }
            public Nullable<System.DateTime> ModifiedDate { get; set; }
        }
    }

}

