﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using APSEED_SCO.Models;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class AgencyController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();


        //Adding Agency
        [HttpPost]
        [Route("Agency/SaveAgency")]
        public HttpResponseMessage SaveAgency(SCO_Agency vagency)
        {
            if (vagency != null)
            {
                if (vagency.Id > 0)
                {
                    SCO_Agency agencyId = APSeedCo_Entity.SCO_Agency
                        .Where(agency => agency.Id == vagency.Id).FirstOrDefault();
                    if (agencyId == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Agency Name does not exists with id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        SCO_Agency agencyObj = new SCO_Agency();
                        agencyId.AgencyName = vagency.AgencyName;
                        agencyId.Address = vagency.Address;
                        agencyId.Email = vagency.Email;
                        agencyId.Description = vagency.Description;
                        agencyId.ModifiedDate = DateTime.Now;
                        agencyId.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Agency updated successfully");
                    }
                }
                else
                {
                    SCO_Agency agencyFind = APSeedCo_Entity.SCO_Agency.Where(agency => agency.AgencyName == vagency.AgencyName).FirstOrDefault();

                    if (agencyFind == null)
                    {
                        SCO_Agency agencyObj = new SCO_Agency();
                        agencyObj.AgencyName = vagency.AgencyName;
                        agencyObj.Address = vagency.Address;
                        agencyObj.Email = vagency.Email;
                        agencyObj.Description = vagency.Description;
                        agencyObj.CreatedDate = DateTime.Now;
                        agencyObj.ModifiedDate = DateTime.Now;
                        agencyObj.IsActive = true;
                        APSeedCo_Entity.SCO_Agency.Add(agencyObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Agency added successfully");

                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {
                            Content = new StringContent($"Agency Name exists with the same Name"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }

            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Fetching  Details of Agencies 
        [HttpGet]
        [Route("Agency/GetAgencies")]
        public HttpResponseMessage GetAgencies()
        {
            var agencyDetails = APSeedCo_Entity.SCO_Agency
                .Where(agency => agency.IsActive == true).ToList();
            List<AgencyNames> agencyObj = new List<AgencyNames>();
            foreach (var sel in agencyDetails)
            {
                AgencyNames vagency = new AgencyNames();
                vagency.Id = sel.Id;
                vagency.AgencyName = sel.AgencyName;
                vagency.Address = sel.Address;
                vagency.Email = sel.Email;
                vagency.Description = sel.Description;
                vagency.IsActive = sel.IsActive;
                agencyObj.Add(vagency);
            }
            if (agencyObj != null)
            {
                return Request.CreateResponse<List<AgencyNames>>(HttpStatusCode.OK, agencyObj);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Get Agency list not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Enable or disable of disabled Agencies

        [HttpGet]
        [Route("Agency/EnabledOrDisabledAgency")]
        public HttpResponseMessage EnabledOrDisabledAgency(int agencyId, bool status)
        {
            var agencyFind = APSeedCo_Entity.SCO_Agency.Where(user => user.Id == agencyId).SingleOrDefault();
            if (agencyFind != null)
            {
                if (status == true)
                {
                    agencyFind.IsActive = false;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Agency disabled successfully");
                }
                else
                {
                    agencyFind.IsActive = true;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Agency Enabled successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"agencyId does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Fetching  Details of  disabled Agencies
        
        [HttpGet]
        [Route("Agency/GetDisableAgencies")]
        public HttpResponseMessage GetDisableAgencies()
        {
            var agencyDetails = APSeedCo_Entity.SCO_Agency
                .Where(agency => agency.IsActive == false).ToList();
            List<AgencyNames> agencyObj = new List<AgencyNames>();
            foreach (var sel in agencyDetails)
            {
                AgencyNames vagency = new AgencyNames();
                vagency.Id = sel.Id;
                vagency.AgencyName = sel.AgencyName;
                vagency.Address = sel.Address;
                vagency.Email = sel.Email;
                vagency.Description = sel.Description;
                agencyObj.Add(vagency);
            }
            if (agencyObj != null)
            {
                return Request.CreateResponse<List<AgencyNames>>(HttpStatusCode.OK, agencyObj);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Disable Agency List not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Fetching  AgencyNames
        [HttpGet]
        [Route("Agency/GetAgenyByNames")]
        public HttpResponseMessage GetAgencyNamesList()
        {
            var agencyList = APSeedCo_Entity.SCO_Agency
                .Where(agency => agency.IsActive == true)
                .Select(agency => new { agency.Id, agency.AgencyName }).ToList();
            List<AgencyNames> agencyNamesList = new List<AgencyNames>();
            foreach (var vsel in agencyList)
            {
                AgencyNames agencyObj = new AgencyNames();
                agencyObj.Id = vsel.Id;
                agencyObj.AgencyName = vsel.AgencyName;
                agencyNamesList.Add(agencyObj);
            }
            if (agencyNamesList != null)
            {
                return Request.CreateResponse<List<AgencyNames>>(HttpStatusCode.OK, agencyNamesList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Agencies are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Agency 
        [HttpGet]
        [Route("Agency/DeleteAgency")]
        public HttpResponseMessage DeleteAgency(int agencyId)
        {
            var agencyFind = APSeedCo_Entity.SCO_Agency
                .Where(agency => agency.Id == agencyId).SingleOrDefault();
            if (agencyFind != null)
            {
                agencyFind.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Agency deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"AgencyId does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        public class AgencyNames
        {
            public long Id { get; set; }
            public string AgencyName { get; set; }
            public string Address { get; set; }
            public string Email { get; set; }
            public string Description { get; set; }
            public bool IsActive { get; set; }
        }

    }
}
