﻿using APSEED_SCO.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class IndentController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();

        // Indent Inserting
        public void SaveIndent(SCO_ProjectAbstract vindent)
        {
            if (vindent != null)
            {
                var indentdetails = APSeedCo_Entity.SCO_IndentFulfilment.Where(indent => indent.WRID == vindent.WRId && indent.AssetId == vindent.AssetId && indent.IsActive == true).SingleOrDefault();
                if (indentdetails != null)
                {
                    indentdetails.AgencyId = vindent.AgencyId;
                    var agencyDetails = APSeedCo_Entity.SCO_Agency
                        .Where(agency => agency.Id == indentdetails.AgencyId).SingleOrDefault();
                    indentdetails.AgencyName = agencyDetails.AgencyName;
                    indentdetails.AssignedFielEmpId = vindent.AssignedTo;
                    indentdetails.IndentStart = true;
                    indentdetails.IndentStop = false;
                    var userDetails = APSeedCo_Entity.SCO_User
                   .Where(user => user.Id == indentdetails.AssignedFielEmpId).SingleOrDefault();
                    indentdetails.FieldEmployee = userDetails.FirstName + userDetails.LastName;
                    APSeedCo_Entity.SaveChanges();
                }
                else
                {
                    SCO_IndentFulfilment indObj = new SCO_IndentFulfilment();
                    indObj.ProjectId = vindent.ProjectId;
                    indObj.WRID = vindent.WRId;
                    var projectDetails = APSeedCo_Entity.SCO_Project.Include("SCO_Location")
                        .Where(proj => proj.Id == indObj.ProjectId).SingleOrDefault();
                    indObj.ProjectName = projectDetails.ProjectName;
                    indObj.AgencyId = vindent.AgencyId;
                    var agencyDetails = APSeedCo_Entity.SCO_Agency
                        .Where(agency => agency.Id == indObj.AgencyId).SingleOrDefault();
                    indObj.AgencyName = agencyDetails.AgencyName;
                    indObj.AssetId = vindent.AssetId;
                    var assetDetails = APSeedCo_Entity.SCO_Assets
                       .Where(asset => asset.Id == indObj.AssetId).SingleOrDefault();
                    indObj.AssetName = assetDetails.Name;
                    indObj.AssetQuantity = vindent.AssetQuantity;
                    indObj.Description = null;
                    indObj.UserId = null;
                    indObj.AssignedFieldAgentName = null;
                    indObj.AssignedFielEmpId = vindent.AssignedTo;
                    if (indObj.AssignedFielEmpId == null || indObj.AssignedFielEmpId == 0)
                    {
                        indObj.FieldEmployee = null;
                        indObj.AssignedFielEmpId = null;
                    }
                    else
                    {
                        indObj.AssignedFielEmpId = vindent.AssignedTo;
                        var userDetails = APSeedCo_Entity.SCO_User
                       .Where(user => user.Id == indObj.AssignedFielEmpId).SingleOrDefault();
                        indObj.FieldEmployee = userDetails.FirstName + userDetails.LastName;
                    }
                    indObj.FulFilledBy = null;
                    if (projectDetails.SCO_Location == null)
                    {
                        indObj.FulfilledAt = null;
                    }
                    else
                    {
                        indObj.FulfilledAt = projectDetails.SCO_Location.Name;
                    }
                    indObj.IndentStatus = "Initialize";
                    indObj.InstallType = vindent.InstallType;
                    indObj.CreatedDate = DateTime.Now;
                    indObj.AssetTypeId = vindent.AssetTypeId;
                    if (indObj.AssetTypeId == null)
                    {
                        indObj.AssetTypeName = null;
                    }
                    else
                    {
                        var assetTypedetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == indObj.AssetTypeId).SingleOrDefault();
                        indObj.AssetTypeName = assetTypedetails.Name;
                    }

                    indObj.ModifiedDate = null;
                    indObj.PicId = null;
                    indObj.FixedAssetCount = null;
                    indObj.FaultDeviceCount = null;
                    indObj.IsActive = true;
                    indObj.IndentStart = true;
                    indObj.IndentStop = false;
                    APSeedCo_Entity.SCO_IndentFulfilment.Add(indObj);
                    APSeedCo_Entity.SaveChanges();
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"please provide atleast one field"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Updating IndentFulfilment
        [HttpPost]
        [Route("Indent/UpdateIndent")]
        public HttpResponseMessage UpdateIndent(SCO_IndentFulfilment vindent)
        {
            if (vindent != null)
            {
                var indentCheck = APSeedCo_Entity.SCO_IndentFulfilment
                    .Where(indF => indF.Id == vindent.Id).SingleOrDefault();
                if (indentCheck == null)
                {
                    throw new HttpResponseException(new HttpResponseMessage
                    {
                        Content = new StringContent($"Indent doesnot exist with the Id"),
                        StatusCode = HttpStatusCode.BadRequest
                    });
                }
                else
                {
                    indentCheck.UserId = vindent.UserId;
                    if (indentCheck.UserId == null)
                    {
                        indentCheck.AssignedFieldAgentName = null;
                    }
                    else
                    {
                        var userDetails = APSeedCo_Entity.SCO_User
                       .Where(user => user.Id == indentCheck.UserId).SingleOrDefault();
                        indentCheck.AssignedFieldAgentName = userDetails.FirstName + userDetails.LastName;
                    }
                    indentCheck.Description = vindent.Description;
                    indentCheck.WRID = vindent.WRID;
                    indentCheck.AssetId = vindent.AssetId;
                    indentCheck.AssetQuantity = vindent.AssetQuantity;
                    indentCheck.IndentStatus = vindent.IndentStatus;
                    indentCheck.FulFilledBy = vindent.FulFilledBy;
                    if (indentCheck.IndentStatus == null)
                    {
                        indentCheck.IndentStatus = "Initialize";
                    }
                    else
                    {
                        indentCheck.IndentStatus = vindent.IndentStatus;
                    }
                    indentCheck.ModifiedDate = DateTime.Now;
                    indentCheck.PicId = vindent.PicId;
                    indentCheck.FixedAssetCount = vindent.FixedAssetCount;
                    indentCheck.FEverifiedCount = indentCheck.FEverifiedCount + vindent.FEverifiedCount;
                    if (indentCheck.FixedAssetCount < indentCheck.FEverifiedCount)
                    {
                        return Request.CreateResponse(HttpStatusCode.BadRequest, "Verified count is more than required Asset count");
                    }
                    if (indentCheck.AssetQuantity <indentCheck.FixedAssetCount)
                    {
                        return Request.CreateResponse(HttpStatusCode.BadRequest, "Installed count is more than required Asset count");
                    }
                    indentCheck.FEVerifiedStatus = vindent.FEVerifiedStatus;
                    indentCheck.FEPicId = vindent.FEPicId;
                    indentCheck.Remarks = vindent.Remarks;
                    indentCheck.IndentStart = vindent.IndentStart;
                    indentCheck.IndentStop = vindent.IndentStop;
                    if (indentCheck.IndentStatus == "Completed")
                    {
                        if (indentCheck.FixedAssetCount == indentCheck.FEverifiedCount)
                        {
                            indentCheck.IsActive = false;
                            APSeedCo_Entity.SaveChanges();
                            return Request.CreateResponse(HttpStatusCode.OK, "Indent      Completed successfully");
                        }
                        else
                        {
                            return Request.CreateResponse(HttpStatusCode.BadRequest, "Asset not yet fixed completely so you cannot close the indent");
                        }

                    }
                    else
                    {
                        indentCheck.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Indent updated successfully");
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"please provide atleast one field"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Getting Project from projectAbstract
        [HttpGet]
        [Route("Indent/GetProjectsOfIndent")]
        public HttpResponseMessage GetProjectsOfIndent()
        {
            var projectDetails = APSeedCo_Entity.SCO_IndentFulfilment
                .Where(ind => ind.IsActive == true).ToList().Select(indent => new { indent.ProjectId,indent.ProjectName }).Distinct();
            List<IndentList> projAbslist = new List<IndentList>();

            foreach (var projId in projectDetails)
            {
                
                IndentList list = new IndentList();
                list.ProjectId = projId.ProjectId;
                list.ProjectName = projId.ProjectName;
                projAbslist.Add(list);
            }
            if (projAbslist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, projAbslist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Districts are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Getting Project from Indent
      
        [HttpGet]
        [Route("Indent/GetProjectsOfIndentByUserId")]
        public HttpResponseMessage GetProjectsOfIndentByUserId(int userId)
        {
            var projectDetails = APSeedCo_Entity.SCO_IndentFulfilment
                .Where(ind => ind.IsActive == true && ind.UserId==userId).ToList().Select(indent => new { indent.ProjectId, indent.ProjectName,indent.IndentStatus}).Distinct();
            List<IndentList> projAbslist = new List<IndentList>();

            foreach (var projId in projectDetails)
            {
                IndentList list = new IndentList();
                list.ProjectId = projId.ProjectId;
                list.ProjectName = projId.ProjectName;
                projAbslist.Add(list);
            }
            if (projAbslist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, projAbslist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Districts are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Getting Project from projectAbstract
        [HttpGet]
        [Route("Indent/GetProjectsOfIndentReports")]
        public HttpResponseMessage GetProjectsOfIndentReports()
        {
            var projectDetails = APSeedCo_Entity.SCO_IndentFulfilment
               .ToList().Select(indent => new { indent.ProjectId,indent.ProjectName}).Distinct();
            List<IndentList> projAbslist = new List<IndentList>();

            foreach (var projId in projectDetails)
            {
                IndentList list = new IndentList();
                list.ProjectId = projId.ProjectId;
                list.ProjectName = projId.ProjectName;
                projAbslist.Add(list);
            }
            if (projAbslist != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, projAbslist);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Districts are not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Get Indent Details
        [HttpGet]
        [Route("Indent/GetIndentDetails")]
        public HttpResponseMessage GetIndentDetails()
        {
            var indentDetails = APSeedCo_Entity.SCO_IndentFulfilment.Where(indent => indent.IsActive == true).ToList();
            if (indentDetails != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, indentDetails);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the indent details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get Indent Details By FieldEmployee
        [HttpGet]
        [Route("Indent/GetIndentDetailsByFieldEmployee")]
        public HttpResponseMessage GetIndentDetailsByFieldEmployeeId(int userId)
        {
            var indentDetails = APSeedCo_Entity.SCO_IndentFulfilment
                .Where(indent => indent.AssignedFielEmpId == userId && indent.IndentStatus != "Initialize" && indent.IsActive == true).ToList();
            if (indentDetails != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, indentDetails);

            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the indent details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get Indent Details By ProjectId
        [HttpGet]
        [Route("Indent/GetIndentDetailsByProjId")]
        public HttpResponseMessage GetIndentDetailsByProjectId(int projectId)
        {
            var indentDetails = APSeedCo_Entity.SCO_IndentFulfilment
                .Where(indent => indent.ProjectId == projectId && indent.IsActive == true).ToList();
            if (indentDetails != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, indentDetails);

            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the indent details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        // Get Indent Details By UserId ProjId
        [HttpGet]
        [Route("Indent/GetIndentDetailsByUserIdProjId")]
        public HttpResponseMessage GetIndentDetailsByUserIdProjId(int userId, int projId)
        {
            var indentDetails = APSeedCo_Entity.SCO_IndentFulfilment
               .Where(indent => indent.UserId == userId && indent.ProjectId == projId).ToList();
            if (indentDetails != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, indentDetails);

            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch the indent details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Indent
        [HttpGet]
        [Route("Project/DeleteIndent")]
        public HttpResponseMessage DeleteIndent(int indentId)
        {
            var projectFind = APSeedCo_Entity.SCO_IndentFulfilment
                .Where(proj => proj.Id == indentId).SingleOrDefault();
            if (projectFind != null)
            {
                projectFind.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Indent deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to delete Please try again "),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Delete projAbstract

        public void DeleteProjAbs(int WrId,int asssetId)
        {
            var projectAbsFind = APSeedCo_Entity.SCO_ProjectAbstract
                .Where(projAbs => projAbs.WRId == WrId && projAbs.AssetId==asssetId && projAbs.IsActive==true).SingleOrDefault();
            if (projectAbsFind != null)
            {
                projectAbsFind.IsActive = false;
                APSeedCo_Entity.SaveChanges();
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to delete Please try again "),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        public class IndentList
        {
            public string ProjectName { get; set; }
            public Nullable<long> ProjectId { get; set; }
            public string IndentStatus { get; set; }

        }

        public class IndentDetails
        {
            public long Id { get; set; }
            public Nullable<long> UserId { get; set; }
            public string ProjectName { get; set; }
            public Nullable<long> ProjectId { get; set; }
            public Nullable<long> AgencyId { get; set; }
            public string AgencyName { get; set; }
            public Nullable<long> AssetId { get; set; }
            public string AssetName { get; set; }
            public long AssetQuantity { get; set; }
            public string Description { get; set; }
            public string IndentStatus { get; set; }
            public string AssignedFieldAgentName { get; set; }
            public string FulFilledBy { get; set; }
            public string InstallType { get; set; }
            public Nullable<System.DateTime> ModifiedDate { get; set; }
            public string FulfilledAt { get; set; }
            public string FaultyDevicePicForReplacement { get; set; }
            public bool IsActive { get; set; }
            public Nullable<System.DateTime> CreatedDate { get; set; }
            public Nullable<long> FixedAssetCount { get; set; }
            public string PicId { get; set; }
            public Nullable<long> AssignedFielEmpId { get; set; }
            public string FieldEmployee { get; set; }
            public Nullable<long> FEverifiedCount { get; set; }
            public string FEVerifiedStatus { get; set; }
            public string Remarks { get; set; }
            public string FEPicId { get; set; }
            public Nullable<long> AssetTypeId { get; set; }
            public string AssetTypeName { get; set; }

            public string purposeOfVisit { get; set; }
        }
    }
}


/*
 *  List<IndentDetails> indentList = new List<IndentDetails>();
            foreach(var sel in indentDetails)
            {
                IndentDetails indObj = new IndentDetails();
                indObj.Id = sel.Id;
                indObj.UserId = sel.UserId;
                indObj.ProjectId = sel.ProjectId;
                indObj.ProjectName = sel.ProjectName;
                indObj.AgencyId = sel.AgencyId;
                indObj.AgencyName = sel.AgencyName;
                indObj.AssetId = sel.AssetId;
                indObj.AssetName = sel.AssetName;
                indObj.AssetQuantity = sel.AssetQuantity;
                indObj.Description = sel.Description;
                indObj.IndentStatus = sel.IndentStatus;
                indObj.AssignedFieldAgentName = sel.AssignedFieldAgentName;
                indObj.AssignedFielEmpId = sel.AssignedFielEmpId;
                indObj.FulFilledBy = sel.FulFilledBy;
                indObj.FulfilledAt = sel.FulfilledAt;
                indObj.InstallType = sel.InstallType;
                indObj.ModifiedDate = sel.ModifiedDate;
                indObj.IsActive = sel.IsActive;
                indObj.FieldEmployee = sel.FieldEmployee;
                indObj.FixedAssetCount = sel.FixedAssetCount;
                indObj.PicId = sel.PicId;
                indObj.FEverifiedCount = sel.FEverifiedCount;
                indObj.FEVerifiedStatus = sel.FEVerifiedStatus;
                indObj.Remarks = sel.Remarks;
                indObj.FEPicId = sel.FEPicId;
                indObj.AssetTypeId = sel.AssetTypeId;
                indObj.AssetTypeName = sel.AssetTypeName;
                var FieldEmpDetails = APSeedCo_Entity.SCO_FieldEmpTracking.Where(feemp => feemp.UserId == indObj.AssignedFielEmpId).SingleOrDefault();
                indObj.purposeOfVisit = FieldEmpDetails.PurposeOfVisit;
            }
*/
