﻿using APSEED_SCO.Helpers;
using APSEED_SCO.Models;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using System.Web.UI;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class UsersController : ApiController
    {

        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();

        // Checking For UserName
        [HttpGet]
        [Route("Users/CheckUserName")]
        public HttpResponseMessage UserCheck(string vuser)
        {
            SCO_User userCheck = APSeedCo_Entity.SCO_User.Where(user => user.UserName == vuser && user.IsActive == true).SingleOrDefault();
            if (userCheck != null)
            {
                return Request.CreateResponse<SCO_User>(HttpStatusCode.OK, userCheck, "UserName already exists");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Add user"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Save User
        [HttpPost]
        [Route("Users/SaveUser")]
        public HttpResponseMessage SaveUser(SCO_User vuser)
        {
            if (vuser != null)
            {
                if (vuser.Id > 0)
                {
                    var userFind = APSeedCo_Entity.SCO_User.Where(b => b.Id == vuser.Id).FirstOrDefault();
                    if (userFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {

                            Content = new StringContent($"User does not exists with this id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        userFind.FirstName = vuser.FirstName;
                        userFind.LastName = vuser.LastName;
                        if (userFind.UserTypeId == null)
                        {
                            userFind.UserTypeId = 1;
                        }
                        else
                        {
                            userFind.UserTypeId = vuser.UserTypeId;
                        }

                        if (userFind.UserRoleId == null)
                        {
                            userFind.UserRoleId = 1;
                        }
                        else
                        {
                            userFind.UserRoleId = vuser.UserRoleId;
                        }
                        userFind.Description = vuser.Description;
                        userFind.ModifiedBy = vuser.ModifiedBy;
                        userFind.ModifiedDate = DateTime.Now;
                        userFind.EmailId = vuser.EmailId;
                        userFind.MobileNumber = vuser.MobileNumber;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "User updated successfully");
                    }
                }
                else
                {
                    var userNameSelect = APSeedCo_Entity.SCO_User
                        .Where(b => b.UserName == vuser.UserName).SingleOrDefault();
                    if (userNameSelect == null)
                    {
                        SCO_User userObj = new SCO_User();
                        userObj.UserName = vuser.UserName;
                        string encryptPassword = Helper.Encrypt(vuser.Password);
                        userObj.Password = encryptPassword;
                        userObj.FirstName = vuser.FirstName;
                        userObj.LastName = vuser.LastName;
                        if (vuser.UserTypeId == null)
                        {
                            userObj.UserTypeId = 1;
                        }
                        else
                        {
                            userObj.UserTypeId = vuser.UserTypeId;
                        }
                        if (vuser.UserRoleId == null)
                        {
                            userObj.UserRoleId = 1;
                        }
                        else
                        {
                            userObj.UserRoleId = vuser.UserRoleId;
                        }
                        userObj.IsActive = true;
                        userObj.Description = vuser.Description;
                        userObj.CreatedBy = vuser.CreatedBy;
                        userObj.CreatedDate = DateTime.Now;
                        userObj.ModifiedBy = vuser.ModifiedBy;
                        userObj.ModifiedDate = DateTime.Now;
                        userObj.EmailId = vuser.EmailId;
                        var mobileNumberCheck = APSeedCo_Entity.SCO_User.Where(user => user.MobileNumber == vuser.MobileNumber).SingleOrDefault();
                        if (mobileNumberCheck == null)
                        {
                            userObj.MobileNumber = vuser.MobileNumber;
                        }
                        else
                        {
                            throw new HttpResponseException(new HttpResponseMessage
                            {

                                Content = new StringContent($"MobileNumber  already exists "),
                                StatusCode = HttpStatusCode.BadRequest
                            });
                        }

                        APSeedCo_Entity.SCO_User.Add(userObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "User created successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {

                            Content = new StringContent($"UserName  already exists "),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get All UserDetails 

        [HttpGet]
        [Route("Users/GetAllUsers")]
        public HttpResponseMessage GetUserList()
        {
            var usersList = APSeedCo_Entity.SCO_User.Include("SCO_UserType").Include("SCO_UserRole").Where(user => user.IsActive == true);

            List<UserList> userDetails = new List<UserList>();
            foreach (var sel in usersList)
            {
                UserList userObj = new UserList();
                userObj.Id = sel.Id;
                userObj.UserName = sel.UserName;
                userObj.Password = sel.Password;
                userObj.FirstName = sel.FirstName;
                userObj.LastName = sel.LastName;
                userObj.MobileNumber = sel.MobileNumber;
                userObj.EmailId = sel.EmailId;
                userObj.UserTypeId = sel.UserTypeId;
                userObj.UserRoleId = sel.UserRoleId;
                userObj.CreatedBy = sel.CreatedBy;
                userObj.IsActive = sel.IsActive;
                userObj.UserType = sel.SCO_UserType.UserType;
                userObj.UserRole = sel.SCO_UserRole.UserRole;
                userObj.CreatedDate = sel.CreatedDate;
                userObj.ModifiedBy = sel.ModifiedBy;
                userObj.ModifiedDate = sel.ModifiedDate;
                userObj.Description = sel.Description;
                userDetails.Add(userObj);
            }
            if (userDetails != null)
            {
                return Request.CreateResponse<List<UserList>>(HttpStatusCode.OK, userDetails);

            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Users not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Get All UserDetails 

        [HttpGet]
        [Route("Users/DisabledUsersList")]
        public HttpResponseMessage GetDisabledUsersList()
        {
            var usersList = APSeedCo_Entity.SCO_User.Include("SCO_UserType").Include("SCO_UserRole").Where(user => user.IsActive == false);
            List<UserList> userDetails = new List<UserList>();
            foreach (var sel in usersList)
            {
                UserList userObj = new UserList();
                userObj.Id = sel.Id;
                userObj.UserName = sel.UserName;
                userObj.Password = sel.Password;
                userObj.FirstName = sel.FirstName;
                userObj.LastName = sel.LastName;
                userObj.MobileNumber = sel.MobileNumber;
                userObj.EmailId = sel.EmailId;
                userObj.UserTypeId = sel.UserTypeId;
                userObj.UserRoleId = sel.UserRoleId;
                userObj.CreatedBy = sel.CreatedBy;
                userObj.IsActive = sel.IsActive;
                userObj.UserType = sel.SCO_UserType.UserType;
                userObj.UserRole = sel.SCO_UserRole.UserRole;
                userObj.CreatedDate = sel.CreatedDate;
                userObj.ModifiedBy = sel.ModifiedBy;
                userObj.ModifiedDate = sel.ModifiedDate;
                userObj.Description = sel.Description;
                userDetails.Add(userObj);
            }
            if (userDetails != null)
            {
                return Request.CreateResponse<List<UserList>>(HttpStatusCode.OK, userDetails);

            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Users not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get User Details By Id
        [HttpGet]
        [Route("Users/GetUserById")]
        public HttpResponseMessage GetUserById(int Id)
        {
            SCO_User user = APSeedCo_Entity.SCO_User.Where(c => c.Id == Id && c.IsActive == true).FirstOrDefault();
            if (user != null)
            {
                return Request.CreateResponse<SCO_User>(HttpStatusCode.OK, user);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Users not available"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        //User Login 
        [HttpGet]
        [Route("Users/UserLogin")]
        public HttpResponseMessage UserLogin(string vuserName, string vpassword)
        {
            string encryptPassword = Helper.Encrypt(vpassword);
            SCO_User userCheck = APSeedCo_Entity.SCO_User.Include("SCO_UserType").Include("SCO_UserRole").Where(user => user.UserName == vuserName && user.Password == encryptPassword && user.IsActive == true).FirstOrDefault();
            if (userCheck != null)
            {
                return Request.CreateResponse<SCO_User>(HttpStatusCode.OK, userCheck);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Invalid Credentials "),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get UserType
        [HttpGet]
        [Route("Users/GetUserType")]
        public HttpResponseMessage GetUserType()
        {
            var userType = APSeedCo_Entity.SCO_UserType.Select(vuser => new { vuser.Id, vuser.UserType });
            List<UserTypeList> vuserType = new List<UserTypeList>();
            foreach (var sel in userType)
            {
                UserTypeList userTypeObj = new UserTypeList();
                userTypeObj.Id = sel.Id;
                userTypeObj.UserType = sel.UserType;
                vuserType.Add(userTypeObj);
            }
            if (vuserType != null)
            {
                return Request.CreateResponse<List<UserTypeList>>(HttpStatusCode.OK, vuserType);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Add userType"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get UserRole
        [HttpGet]
        [Route("Users/GetUserRole")]
        public HttpResponseMessage GetUserRole()
        {
            var userRole = APSeedCo_Entity.SCO_UserRole.Select(vuser => new { vuser.Id, vuser.UserRole });
            List<UserRoleList> vuserRole = new List<UserRoleList>();
            foreach (var sel in userRole)
            {
                UserRoleList userRoleObj = new UserRoleList();
                userRoleObj.Id = sel.Id;
                userRoleObj.UserRole = sel.UserRole;
                vuserRole.Add(userRoleObj);
            }
            if (vuserRole != null)
            {
                return Request.CreateResponse<List<UserRoleList>>(HttpStatusCode.OK, vuserRole);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Add userRole"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete User 
        [HttpGet]
        [Route("Users/DeleteUser")]
        public HttpResponseMessage DeleteUser(int userId)
        {
            var userFind = APSeedCo_Entity.SCO_User.Where(user => user.Id == userId).SingleOrDefault();
            if (userFind != null)
            {
                userFind.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "User deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"UserId does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get List of disabled Users
        [HttpGet]
        [Route("Users/EnabledOrDisabledUser")]

        public HttpResponseMessage DiasbledUsersList(int userId, bool status)
        {
            var userFind = APSeedCo_Entity.SCO_User.Where(user => user.Id == userId).SingleOrDefault();
            if (userFind != null)
            {
                if (status == true)
                {
                    userFind.IsActive = false;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "User disabled successfully");
                }
                else
                {
                    userFind.IsActive = true;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "User Enabled successfully");
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"UserId does not exists"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Users/GetUserprojectCounts")]

        public HttpResponseMessage GetUserProjectCounts(int userId)
        {
            List<UsersCount> listObj = new List<UsersCount>();
            var projectAbstarctCount = APSeedCo_Entity.SCO_ProjectAbstract.Where(proj => proj.AssignedTo == userId && proj.IsActive == true).Count();
            var workRequestCount = APSeedCo_Entity.SCO_WorkRequest.Where(wr => wr.UserId == userId && wr.IsActive == true).Count();
            UsersCount cntObj = new UsersCount();
            cntObj.ProjectCount = projectAbstarctCount;
            cntObj.WorkRequestcount = workRequestCount;
            listObj.Add(cntObj);
            if (listObj != null)
            {
                return Request.CreateResponse<List<UsersCount>>(HttpStatusCode.OK, listObj);
            }
            else
            {

                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch count"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        [HttpGet]
        [Route("Users/ForgotPassword")]
        public string UserValidate(string phoneNumber, string user)
        {
            long phoneno = Convert.ToInt64(phoneNumber);
            var userDetails = APSeedCo_Entity.SCO_User.Where(i => i.UserName == user && i.MobileNumber == phoneno).SingleOrDefault();
            if (userDetails == null)
            {
                return "Invalid Combination.";
            }
            else
            {
                string otp = GetNewOTP();
                SendsmstoReferral(phoneNumber, "Dear " + User + ", your OTP for verification is " + otp);
                return otp;
            }
        }

        public void SendsmstoReferral(string mobile, string message)
        {
            string userName = ConfigurationManager.AppSettings["smsUN"];
            string password = ConfigurationManager.AppSettings["smsPW"];
            string senderid = ConfigurationManager.AppSettings["smsId"];

            SmsGateway obj = new SmsGateway();
            string strPostResponse;
            strPostResponse = obj.SendSMS(userName, password, senderid, mobile, message);
        }

        private static string GetNewOTP()
        {
            var chars = "0123456789";
            var random = new Random();
            var result = new string(
                Enumerable.Repeat(chars, 6)
                          .Select(s => s[random.Next(s.Length)])
                          .ToArray());
            return result;
        }

        // Save Forgot Password 
        [HttpGet]
        [Route("Users/SaveNewPassword")]
        public HttpResponseMessage SaveNewPassword(string UserName, long MobileNumber, string Password)
        {
            var userDetails = APSeedCo_Entity.SCO_User.Where(user => user.UserName == UserName && user.MobileNumber == MobileNumber).SingleOrDefault();
            string encryptPassword = Helper.Encrypt(Password);
            userDetails.Password = encryptPassword;
            APSeedCo_Entity.SaveChanges();
            return Request.CreateResponse(HttpStatusCode.OK, "Password changed successfully");
        }

        [HttpGet]
        [Route("Users/ChangePassword")]

        public HttpResponseMessage ChangePassword(string UserName, string oldPassword, string NewPassword)
        {
            string encryptPassword = Helper.Encrypt(oldPassword);
            string NewencryptPassword = Helper.Encrypt(NewPassword);
            var userDetails = APSeedCo_Entity.SCO_User
                .Where(user => user.UserName == UserName && user.Password == encryptPassword).SingleOrDefault();
            userDetails.Password = NewencryptPassword;
            APSeedCo_Entity.SaveChanges();
            return Request.CreateResponse(HttpStatusCode.OK, "Password changed successfully");

        }


        // Get Agency and Installers

        [HttpGet]
        [Route("Users/GetIndentUsers")]
        public HttpResponseMessage GetIndentUsers()
        {
            var indentUsers = APSeedCo_Entity.SCO_User.Include("SCO_UserType").Include("SCO_UserRole").Where(user => user.UserTypeId == 4 || user.UserTypeId == 5 && user.IsActive==true).ToList();
            List<IndentUserList> userList = new List<IndentUserList>();
            foreach (var sel in indentUsers)
            {
                IndentUserList userObj = new IndentUserList();
                userObj.Id = sel.Id;
                userObj.UserName = sel.FirstName+sel.LastName;
                userObj.UserTypeId = sel.UserTypeId;
                if (sel.SCO_UserType == null)
                {
                    userObj.UserType = null;
                }
                else
                {
                    userObj.UserType = sel.SCO_UserType.UserType;
                }
                userList.Add(userObj);
            }
            if (userList != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, userList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }

        }
        // Get Agency and Installers

        [HttpGet]
        [Route("Users/GetProjAbsUsers")]
        public HttpResponseMessage GetProjAbsUsers()
        {
            var indentUsers = APSeedCo_Entity.SCO_User.Include("SCO_UserType").Include("SCO_UserRole").Where(user => user.UserTypeId == 2 || user.UserTypeId == 3 && user.IsActive==true).ToList();
            List<IndentUserList> userList = new List<IndentUserList>();
            foreach (var sel in indentUsers)
            {
                IndentUserList userObj = new IndentUserList();
                userObj.Id = sel.Id;
                userObj.UserName = sel.FirstName + sel.LastName;
                userObj.UserTypeId = sel.UserTypeId;
                if (sel.SCO_UserType == null)
                {
                    userObj.UserType = null;
                }
                else
                {
                    userObj.UserType = sel.SCO_UserType.UserType;
                }
                userList.Add(userObj);
            }
            if (userList != null)
            {
                return Request.CreateResponse(HttpStatusCode.OK, userList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Failed to fetch details"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

    }
}


// Class related to UserType
public class UserTypeList
{
    public long Id { get; set; }
    public string UserType { get; set; }
}

// Class related to UserRole
public class UserRoleList
{
    public long Id { get; set; }
    public string UserRole { get; set; }
}

// Class related to UserList

public class UserList
{
    public long Id { get; set; }
    public string UserName { get; set; }
    public string Password { get; set; }
    public string FirstName { get; set; }
    public string LastName { get; set; }
    public Nullable<long> UserTypeId { get; set; }
    public Nullable<long> UserRoleId { get; set; }
    public bool IsActive { get; set; }
    public string Description { get; set; }
    public string CreatedBy { get; set; }
    public Nullable<System.DateTime> CreatedDate { get; set; }
    public string ModifiedBy { get; set; }
    public Nullable<System.DateTime> ModifiedDate { get; set; }
    public string EmailId { get; set; }
    public Nullable<long> MobileNumber { get; set; }
    public string UserType { get; set; }
    public string UserRole { get; set; }
}

public class UsersCount
{
    public int ProjectCount { get; set; }
    public int WorkRequestcount { get; set; }
}

public class IndentUserList
{
    public long Id { get; set; }
    public string UserName { get; set; }
    public Nullable<long> UserTypeId { get; set; }
    public string UserType { get; set; }
}

