﻿using APSEED_SCO.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web;
using System.Web.Http;

namespace APSEED_SCO.Controllers
{
    [Route("api/")]
    public class InventoryController : ApiController
    {
        readonly APSEEDCO_SCOEntities APSeedCo_Entity = new APSEEDCO_SCOEntities();

        // Save Asset
        [HttpPost]
        [Route("Inventory/SaveAssets")]
        public HttpResponseMessage SaveAsset(SCO_Assets vassets)
        {
            if (vassets != null)
            {
                if (vassets.Id > 0)
                {
                    var assetFind = APSeedCo_Entity.SCO_Assets.Where(assets => assets.Id == vassets.Id).SingleOrDefault();
                    if (assetFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {

                            Content = new StringContent($"Assets are not available with the Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {
                        assetFind.Name = vassets.Name;
                        assetFind.TypeOfAssetId = vassets.TypeOfAssetId;
                        assetFind.PricePerUnit = vassets.PricePerUnit;
                        assetFind.Description = vassets.Description;
                        assetFind.ModifiedBy = vassets.ModifiedBy;
                        assetFind.IsActive = true;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Assets updated  successfully");
                    }
                }
                else
                {
                    SCO_Assets assetObj = new SCO_Assets();
                    var assetDetails = APSeedCo_Entity.SCO_Assets.Where(asset => asset.Name == vassets.Name).SingleOrDefault();
                    if (assetDetails == null)
                    {
                        assetObj.Name = vassets.Name;
                        assetObj.TypeOfAssetId = vassets.TypeOfAssetId;
                        assetObj.PricePerUnit = vassets.PricePerUnit;
                        assetObj.ModifiedBy = vassets.ModifiedBy;
                        assetObj.Description = vassets.Description;
                        assetObj.CreatedDate = DateTime.Now;
                        assetObj.CreatedBy = vassets.CreatedBy;
                        assetObj.IsActive = true;
                        APSeedCo_Entity.SCO_Assets.Add(assetObj);
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Assets created  successfully");
                    }
                    else
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {

                            Content = new StringContent($"Please provide unique assetname"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                }

            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Get Assets Based on AssetTypeId
        [HttpGet]
        [Route("Inventory/GetAssetsByAssetTypeId")]
        public HttpResponseMessage GetAssetsByAssetTypeId(int assetTypeId)
        {
            var assetDetails = APSeedCo_Entity.SCO_Assets.Where(asset => asset.TypeOfAssetId == assetTypeId && asset.IsActive == true).ToList();
            List<AssetsList> assetObj = new List<AssetsList>();
            foreach (var sel in assetDetails)
            {
                AssetsList vasset = new AssetsList();
                vasset.Id = sel.Id;
                vasset.AssetName = sel.Name;
                vasset.TypeOfAssetId = sel.TypeOfAssetId;
                var assetTypeDetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == sel.TypeOfAssetId).SingleOrDefault();
                vasset.AssetType = assetTypeDetails.Name;
                vasset.CreatedBy = sel.CreatedBy;
                vasset.PricePerUnit = sel.PricePerUnit;
                vasset.Description = sel.Description;
                vasset.ModifiedBy = sel.ModifiedBy;
                assetObj.Add(vasset);

            }
            if (assetObj != null)
            {
                return Request.CreateResponse<List<AssetsList>>(HttpStatusCode.OK, assetObj);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Assets are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        // Delete Assets
        [HttpGet]
        [Route("Inventory/DeleteAsset")]

        public HttpResponseMessage DeleteAsset(int assetId)
        {
            var assetDelete = APSeedCo_Entity.SCO_Assets.Where(assets => assets.Id == assetId).SingleOrDefault();
            if (assetDelete != null)
            {
                assetDelete.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Asset deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Cannot be deleted please try Again"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }
        
        // Get Assets
        [HttpGet]
        [Route("Inventory/GetAssets")]
        public HttpResponseMessage GetAssets()
        {
            var assetsList = APSeedCo_Entity.SCO_Assets
                .Where(assets => assets.IsActive == true).ToList();
            List<AssetsList> assetObj = new List<AssetsList>();
            foreach (var sel in assetsList)
            {
                AssetsList vasset = new AssetsList();
                vasset.Id = sel.Id;
                vasset.AssetName = sel.Name;
                vasset.TypeOfAssetId = sel.TypeOfAssetId;
                var assetDetails = APSeedCo_Entity.C_SCO_TypeOfAsset.Where(asset => asset.Id == vasset.TypeOfAssetId).SingleOrDefault();
                vasset.AssetType = assetDetails.Name;
                vasset.PricePerUnit = sel.PricePerUnit;
                vasset.CreatedDate = sel.CreatedDate;
                vasset.Description = sel.Description;
                vasset.ModifiedBy = sel.ModifiedBy;
                assetObj.Add(vasset);
            }

            if (assetObj != null)
            {
                return Request.CreateResponse<List<AssetsList>>(HttpStatusCode.OK, assetObj);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Assets are not avaliable"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        //  Save Inventory
        [HttpPost]
        [Route("Inventory/SaveInventory")]
        public HttpResponseMessage SaveInventory(SCO_Inventory vinventory)
        {
            if (vinventory != null)
            {
                if (vinventory.Id > 0)
                {
                    var inventoryFind = APSeedCo_Entity.SCO_Inventory
                        .Where(inventory => inventory.Id == vinventory.Id).SingleOrDefault();
                    if (inventoryFind == null)
                    {
                        throw new HttpResponseException(new HttpResponseMessage
                        {

                            Content = new StringContent($"Inventory is not available with Id"),
                            StatusCode = HttpStatusCode.BadRequest
                        });
                    }
                    else
                    {                       
                        inventoryFind.AssetTypeId = vinventory.AssetTypeId;
                        inventoryFind.AssetId = vinventory.AssetId;
                        var assetDetails = APSeedCo_Entity.SCO_Assets
                            .Where(assets => assets.Id ==   inventoryFind.AssetId).SingleOrDefault();
                        inventoryFind.Name = assetDetails.Name;
                        inventoryFind.Description = vinventory.Description;
                        inventoryFind.PricePerUnit = assetDetails.PricePerUnit;
                        inventoryFind.AssetQuantity = vinventory.AssetQuantity;
                        inventoryFind.FaultQuantity = vinventory.FaultQuantity;
                        inventoryFind.ModifiedBy = vinventory.ModifiedBy;
                        inventoryFind.WrId = vinventory.WrId;
                        inventoryFind.PicId = vinventory.PicId;
                        inventoryFind.InventoryStart = vinventory.InventoryStart;
                        inventoryFind.InventoryStop = vinventory.InventoryStop;
                        inventoryFind.DNoticeId = vinventory.DNoticeId;
                        inventoryFind.IsActive = false;
                        inventoryFind.IsVerified = false;
                        inventoryFind.InvoiceNumber = vinventory.InvoiceNumber;
                        APSeedCo_Entity.SaveChanges();
                        return Request.CreateResponse(HttpStatusCode.OK, "Inventory updated successfully");
                    }
                }
                else
                {
                    SCO_Inventory inventoryObj = new SCO_Inventory();
                    inventoryObj.AssetTypeId = vinventory.AssetTypeId;
                    inventoryObj.AssetId = vinventory.AssetId;
                    var assetDetails = APSeedCo_Entity.SCO_Assets
                           .Where(assets => assets.Id == inventoryObj.AssetId).SingleOrDefault();
                    inventoryObj.Name = assetDetails.Name;
                    inventoryObj.Description = vinventory.Description;
                    inventoryObj.PricePerUnit = assetDetails.PricePerUnit;
                    inventoryObj.AssetQuantity = vinventory.AssetQuantity;
                    inventoryObj.FaultQuantity = vinventory.FaultQuantity;
                    inventoryObj.CreatedBy = vinventory.CreatedBy;
                    inventoryObj.CreatedDate = DateTime.Now;
                    inventoryObj.PicId = vinventory.PicId;
                    inventoryObj.DNoticeId = vinventory.DNoticeId;
                    inventoryObj.InventoryStart = true;
                    inventoryObj.InventoryStop = false;
                    inventoryObj.IsActive = false;
                    inventoryObj.IsVerified = false;
                    inventoryObj.InvoiceNumber = vinventory.InvoiceNumber;
                    APSeedCo_Entity.SCO_Inventory.Add(inventoryObj);
                    APSeedCo_Entity.SaveChanges();
                    long invId = Convert.ToInt64(APSeedCo_Entity.SCO_Inventory
                            .Max(c => (long?)c.Id));
                    return Request.CreateResponse(HttpStatusCode.OK, invId);
                }
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"Error"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Delete Inventory
        [HttpGet]
        [Route("Inventory/DeleteInventory")]
        public HttpResponseMessage DeleteInventory(int inventoryId)
        {
            var inventoryDelete = APSeedCo_Entity.SCO_Inventory.Where(inv => inv.Id == inventoryId).SingleOrDefault();
            if (inventoryDelete != null)
            {
                inventoryDelete.IsActive = false;
                APSeedCo_Entity.SaveChanges();
                return Request.CreateResponse(HttpStatusCode.OK, "Inventory deleted successfully");
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Cannot be deleted please try Again"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get InventoryList 
        [HttpGet]
        [Route("Inventory/GetInventory")]
        public HttpResponseMessage GetInventoryList()
        {
            var getInventoryList = APSeedCo_Entity.SCO_Inventory.Include("SCO_Assets").Include("C_SCO_TypeOfAsset").Where(inv => inv.IsActive == true && inv.IsVerified==true && inv.WrId ==null).ToList().OrderByDescending(inv=>inv.CreatedDate);
            List<InventoryList> supInvList = new List<InventoryList>();
            foreach (var sel in getInventoryList)
            {
                InventoryList invObj = new InventoryList();
                invObj.Id = sel.Id;
                invObj.AssetId = sel.AssetId;
                if (sel.SCO_Assets == null)
                {
                    invObj.AssetName = null;
                }
                else
                {
                    invObj.AssetName = sel.SCO_Assets.Name;
                }
                invObj.AssetTypeId = sel.AssetTypeId;
                if (sel.C_SCO_TypeOfAsset == null)
                {
                    invObj.TypeName = null;
                }
                else
                {
                    invObj.TypeName = sel.C_SCO_TypeOfAsset.Name;
                }

                invObj.PricePerUnit = sel.PricePerUnit;
                invObj.AssetQuantity = sel.AssetQuantity;
                invObj.FaultQuantity = sel.FaultQuantity;
                invObj.Description = sel.Description;
                invObj.CreatedDate = sel.CreatedDate;
                invObj.ModifiedBy = sel.ModifiedBy;
                invObj.CreatedBy = sel.CreatedBy;
                invObj.InventoryStart = sel.InventoryStart;
                invObj.InventoryStop = sel.InventoryStop;
                invObj.PicId = sel.PicId;
                invObj.DeliveryNoticeId = sel.DNoticeId;
                invObj.InventoryName = sel.Name;
                invObj.InvoiceNumber = sel.InvoiceNumber;
                supInvList.Add(invObj);
            }
            if (supInvList != null)
            {
                return Request.CreateResponse<List<InventoryList>>(HttpStatusCode.OK, supInvList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"InventoryList not foud with the supplierId"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get InventoryList 
        [HttpGet]
        [Route("Inventory/GetAdminInventory")]
        public HttpResponseMessage GetAdminInventoryList()
        {
            var getInventoryList = APSeedCo_Entity.SCO_Inventory.Include("SCO_Assets").Include("C_SCO_TypeOfAsset").Where(inv => inv.IsActive == false && inv.IsVerified==true && inv.WrId == null).ToList().OrderByDescending(inv => inv.CreatedDate);
            List<InventoryList> supInvList = new List<InventoryList>();
            foreach (var sel in getInventoryList)
            {
                InventoryList invObj = new InventoryList();
                invObj.Id = sel.Id;
                invObj.AssetId = sel.AssetId;
                if (sel.SCO_Assets == null)
                {
                    invObj.AssetName = null;
                }
                else
                {
                    invObj.AssetName = sel.SCO_Assets.Name;
                }
                invObj.AssetTypeId = sel.AssetTypeId;
                if (sel.C_SCO_TypeOfAsset == null)
                {
                    invObj.TypeName = null;
                }
                else
                {
                    invObj.TypeName = sel.C_SCO_TypeOfAsset.Name;
                }
                invObj.PricePerUnit = sel.PricePerUnit;
                invObj.AssetQuantity = sel.AssetQuantity;
                invObj.FaultQuantity = sel.FaultQuantity;
                invObj.Description = sel.Description;
                invObj.CreatedDate = sel.CreatedDate;
                invObj.ModifiedBy = sel.ModifiedBy;
                invObj.CreatedBy = sel.CreatedBy;
                invObj.PicId = sel.PicId;
                invObj.InventoryStart = sel.InventoryStart;
                invObj.InventoryStop = sel.InventoryStop;
                invObj.DeliveryNoticeId = sel.DNoticeId;
                invObj.InventoryName = sel.Name;
                invObj.InvoiceNumber = sel.InvoiceNumber;
                supInvList.Add(invObj);
            }
            if (supInvList != null)
            {
                return Request.CreateResponse<List<InventoryList>>(HttpStatusCode.OK, supInvList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"InventoryList not foud with the supplierId"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }

        // Get InventoryList 
        [HttpGet]
        [Route("Inventory/GetFeildEmpInventory")]
        public HttpResponseMessage GetFeildEmpInventory()
        {
            var getInventoryList = APSeedCo_Entity.SCO_Inventory.Include("SCO_Assets").Include("C_SCO_TypeOfAsset").Where(inv => inv.IsActive == false && inv.IsVerified == false && inv.WrId == null).ToList().OrderByDescending(inv => inv.CreatedDate);
            List<InventoryList> supInvList = new List<InventoryList>();
            foreach (var sel in getInventoryList)
            {
                InventoryList invObj = new InventoryList();
                invObj.Id = sel.Id;
                invObj.AssetId = sel.AssetId;
                if (sel.SCO_Assets == null)
                {
                    invObj.AssetName = null;
                }
                else
                {
                    invObj.AssetName = sel.SCO_Assets.Name;
                }
                invObj.AssetTypeId = sel.AssetTypeId;
                if (sel.C_SCO_TypeOfAsset == null)
                {
                    invObj.TypeName = null;
                }
                else
                {
                    invObj.TypeName = sel.C_SCO_TypeOfAsset.Name;
                }

                invObj.PricePerUnit = sel.PricePerUnit;
                invObj.AssetQuantity = sel.AssetQuantity;
                invObj.FaultQuantity = sel.FaultQuantity;
                invObj.Description = sel.Description;
                invObj.CreatedDate = sel.CreatedDate;
                invObj.ModifiedBy = sel.ModifiedBy;
                invObj.CreatedBy = sel.CreatedBy;
                invObj.PicId = sel.PicId;
                invObj.InventoryStart = sel.InventoryStart;
                invObj.InventoryStop = sel.InventoryStop;
                invObj.DeliveryNoticeId = sel.DNoticeId;
                invObj.InventoryName = sel.Name;
                invObj.InvoiceNumber = sel.InvoiceNumber;
                supInvList.Add(invObj);
            }
            if (supInvList != null)
            {
                return Request.CreateResponse<List<InventoryList>>(HttpStatusCode.OK, supInvList);
            }
            else
            {
                throw new HttpResponseException(new HttpResponseMessage
                {
                    Content = new StringContent($"InventoryList not foud with the supplierId"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
        }


        // Admin SignOff
        [HttpGet]
        [Route("Inventory/AdminSignOff")]

        public HttpResponseMessage AdminSignOff(int invId,string AdminSign)
        {
            var inventoryFind = APSeedCo_Entity.SCO_Inventory
                       .Where(inventory => inventory.Id == invId).SingleOrDefault();
            if (inventoryFind == null)
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Inventory is not available with Id"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
            else
            {
                if (AdminSign =="rejected")
                {
                    inventoryFind.IsActive = false;
                    inventoryFind.IsVerified = false;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Admin");
                }
                else
                {
                    inventoryFind.AdminSignOff = AdminSign;
                    inventoryFind.IsActive = true;
                    inventoryFind.IsVerified = true;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Admin signed successfully");
                }
               
            }
        }

        //Move to Sign Off
        [HttpGet]
        [Route("Inventory/MoveToSignOff")]
        public HttpResponseMessage MoveToSignOff(int invId)
        {
            var inventoryFind = APSeedCo_Entity.SCO_Inventory
                       .Where(inventory => inventory.Id == invId).SingleOrDefault();
            if (inventoryFind == null)
            {
                throw new HttpResponseException(new HttpResponseMessage
                {

                    Content = new StringContent($"Inventory is not available with Id"),
                    StatusCode = HttpStatusCode.BadRequest
                });
            }
            else
            {                        
                    inventoryFind.IsVerified = true;
                    APSeedCo_Entity.SaveChanges();
                    return Request.CreateResponse(HttpStatusCode.OK, "Success");
            }
        }
        public class AssetsList
        {
            public long Id { get; set; }
            public string AssetName { get; set; }
            public Nullable<long> TypeOfAssetId { get; set; }
            public string AssetType { get; set; }
            public string Description { get; set; }
            public long AssetQuantity { get; set; }
            public Nullable<decimal> PricePerUnit { get; set; }
            public string ModifiedBy { get; set; }
            public string CreatedBy { get; set; }
            public Nullable<System.DateTime> CreatedDate { get; set; }
        }

        public class InventoryList
        {
            public long Id { get; set; }
            public Nullable<long> AssetId { get; set; }
            public Nullable<long> AssetTypeId { get; set; }
            public string AssetName { get; set; }
            public string TypeName { get; set; }
            public string InventoryName { get; set; }
            public string Description { get; set; }
            public string PicId { get; set; }
            public Nullable<System.DateTime> CreatedDate { get; set; }
            public string DeliveryNoticeId { get; set; }
            public long AssetQuantity { get; set; }
            public long FaultQuantity { get; set; }
            public Nullable<decimal> PricePerUnit { get; set; }
            public Nullable<bool> InventoryStart { get; set; }
            public Nullable<bool> InventoryStop { get; set; }
            public string ModifiedBy { get; set; }
            public string CreatedBy { get; set; }
            public string InvoiceNumber { get; set; }

        }
    }
}


//Insert Image
//[HttpPost]
//[Route("Inventory/InsertDNotice")]
//public HttpResponseMessage InsertDNoticeImage(long inventId)
//{
//    string imageName = null;
//    HttpFileCollection fileCollection = HttpContext.Current.Request.Files;
//    string ids = "";
//    string timestamp = DateTime.Now.ToString("yyyyMMddHHmmssfff");
//  //  Upload image
//    for (int i = 0; i <= fileCollection.Count - 1; i++)
//    {
//        var postedfile = fileCollection[i];
//      //  Create custom FileName
//        imageName = Path.GetFileNameWithoutExtension(postedfile.FileName);
//        string Folderpath = postedfile.FileName;
//        string imagexte = Path.GetExtension(postedfile.FileName);
//        string ProjectFolder = Folderpath.Split('/')[0];
//        if (ProjectFolder == "Inventory")
//        {
//            string subdirInv = @"C:\Projects\APSEEDCO\Pictures\" + ProjectFolder;
//            string subdirInv = @"E:\NetworkObjects\Projects\APSEED\APSeedSevice\APSEED_SCO\Pictures\" + ProjectFolder;
//            if (!Directory.Exists(subdirInv))
//            {
//                Directory.CreateDirectory(subdirInv);
//            }
//            var filePathInv = HttpContext.Current.Server.MapPath("~/Pictures/" + ProjectFolder + '/' + imageName + '_' + timestamp + imagexte);
//            var pathNameInv = "Pictures/" + ProjectFolder + '/' + imageName + '_' + timestamp + imagexte;
//            postedfile.SaveAs(filePathInv);
//            ImageBlob imageObjInv = new ImageBlob();
//            imageObjInv.ImagePath = pathNameInv;
//            imageObjInv.CreatedDate = DateTime.Now;
//            imageObjInv.ModifiedDate = DateTime.Now;
//            imageObjInv.IsActive = true;
//            APSeedCo_Entity.ImageBlobs.Add(imageObjInv);
//            APSeedCo_Entity.SaveChanges();
//            var idCollect = APSeedCo_Entity.ImageBlobs
//                .Where(c => c.ImagePath == imageObjInv.ImagePath).SingleOrDefault();
//            if (idCollect != null)
//            {
//                ids = Convert.ToString(idCollect.Id) + ";" + ids;
//            }
//        }

//    }

//    if (ids != "")
//    {
//        var getInventory = APSeedCo_Entity.SCO_Inventory.Where(inv => inv.Id == inventId && inv.IsActive == true).SingleOrDefault();

//        if (getInventory != null)
//        {
//            getInventory.DNoticeId = getInventory.DNoticeId + ids;
//            APSeedCo_Entity.SaveChanges();
//        }
//        return Request.CreateResponse(HttpStatusCode.OK, "Success");
//    }
//    else
//    {
//        return Request.CreateResponse(HttpStatusCode.OK, "Not attached any images");
//    }
//}